/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 27. Juli 2017
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sec;

import java.util.Map;

/**
 * <p>An interface for exposing OAuth credentials to applications.</p>
 * 
 * <p>Most implementations also implement {@link DomainPrincipal},
 * but there might be situations, where we only use a forwarded
 * or persisted OAuth bearer token, which does not originate from
 * a login service.</p>   
 */
public interface OAuthCredentials {

    /**
     * @return A currently valid bearer token to use in a
     *     <code>Authentication: Bearer &lt;token&gt;</code>
     *     header to be passed to a resource server.
     */
    public String getBearerToken();
    
    
    /**
     * @return A read-only map of additional attributes we known,
     *    e.g. some well-known OpenID Connect properties.
     *    May return <code>null</code>, if we have no additional
     *    user information at hands.
     */
    public Map<String,String> getAdditionalAttributes();
    
    /**
     * A convenience accessor to additional attributes.
     * 
     * @param key A key to look up on the set of additional attributes.s
     * @return An attribute value contained in the map returned by
     *    {@link #getAdditionalAttributes()}. MAy be <code>null</code>,
     *    if there is no value to the requested attribute 
     */
    public String getAdditionalAttribute(String key);
}
