/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 14.08.2018
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sec;

/**
 * <p>An add-on interface for principals, which are multi-factor authenticated.</p>
 * 
 * <p>Most implementations also implement {@link DomainPrincipal},
 * but there might be situations, where this interface is implemented.</p>   
 */
public interface MFAPrincipal {

    /**
     * @return A mobile phone number to deliver ephemeral tokens to.
     *         If <code>null</code> is returned, ephemeral tokens are not supported.
     */
    public String getMobileNumber();
    
    /**
     * @return A list of token IDs known to be associated to the user.
     *         If <code>null</code> is returned, token authentication is not supported.
     */
    public String[] getKnownTokenIds();

}
