/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 08.03.2021
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sec;

import java.security.Principal;

import javax.security.auth.x500.X500Principal;

/**
 * A resolver for identities fetched from external authentication services like
 * X.509 peer authentication or OAuth credential.
 */
public interface DomainPrincipalResolver {

    /**
     * @param principal A principal like {@link X500Principal} or a principal 
     *                  implementing {@link OAuthCredentials}.
     * @return The resolved domain principal.
     */
    public DomainPrincipal resolvePrincipal(Principal principal);
}
