/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 29.08.2012
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sec;

import java.security.Principal;

/**
 * This interface provides provides clear distinction between domain and group.
 * 
 * {@link Principal#getName()} sometimes and our {@link #getName()} return domain + "/" + username.
 * {@link #getUserName()} by definition only returns the username. 
 * {@link #getDomain()} by definition only returns the login domain.
 *
 */
public interface DomainPrincipal extends Principal {

    /**
     * @return domain + "/" + user name
     */
    public String getName();
    
    /**
     * @return the user name, without any domain parts
     */
    public String getUserName();

    /**
     * @return the user name in a pretty variant, like real world names suitable for greetings
     */
    public String getPrettyName();

    /**
     * @return the name of the login domain (not some DNS domain)
     */
    public String getDomain();
 
    /**
     * @return the e-mail address of the user, if any is known, null otherwise
     */
    public String getEMailAddress();
    
}
