/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 24.09.2017
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sec;

import org.mindrot.jbcrypt.BCrypt;

/**
 * @author wglas
 *
 */
public class BCryptPasswordHasher implements PasswordHasher {

    private final int logRounds;
    
    public BCryptPasswordHasher(int logRounds) {
        
        this.logRounds = logRounds;
    }
    
    public BCryptPasswordHasher() {
        
        this(10);
    }
    
    /* (non-Javadoc)
     * @see org.clazzes.util.sec.PasswordHasher#hashPassword(java.lang.String)
     */
    @Override
    public String hashPassword(String cleartext) {
       
        String salt = BCrypt.gensalt(this.logRounds,HashTools.getSecureRandom());
        
        return this.hashPassword(cleartext,salt);
    }

    /* (non-Javadoc)
     * @see org.clazzes.util.sec.PasswordHasher#hashPassword(java.lang.String, java.lang.String)
     */
    @Override
    public String hashPassword(String cleartext, String salt) {
        
        return "{BCRYPT}" + BCrypt.hashpw(cleartext,salt);
    }

    /* (non-Javadoc)
     * @see org.clazzes.util.sec.PasswordHasher#checkPassword(java.lang.String, java.lang.String)
     */
    @Override
    public boolean checkPassword(String cleartext, String hashed) {
        
        if (hashed.startsWith("{BCRYPT}")) {
        
            return BCrypt.checkpw(cleartext,hashed.substring(8));
        }
        else {
            return false;
        }
    }

    /* (non-Javadoc)
     * @see org.clazzes.util.sec.PasswordHasher#getAlgorithmName()
     */
    @Override
    public String getAlgorithmName() {
        
        return "BCRYPT";
    }

    /* (non-Javadoc)
     * @see org.clazzes.util.sec.PasswordHasher#getSaltLength()
     */
    @Override
    public int getSaltLength() {
        
        return 29;
    }

}
