/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 01.11.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.ryu;

/**
 * Options for the RYU formatter, which will be passed bitwise ORed.
 */
public interface RyuOptions {

    /**
     * Default options, do not show dot zero.
     */
    public static final int DEFAULT = 0;

    /**
     * Whether to show trailing dot-zero like printing <code>2.0</code> instead of <code>2</code>.
     * This option has the additional side-effect, that for denormalized numbers 2 digits
     * are printed, even if only 1 digit is needed. (e.g. 4.9e-324 instead of 5e-324)
     */
    public static final int SHOW_DOT_ZERO = 1 << 0;

    /**
     * Force a scientific notation.
     */
    public static final int SCIENTIFIC = 1 << 1;
}
