/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 01.11.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

// This code has been imported from
//
//   https://github.com/ulfjack/ryu/blob/master/src/main/java/info/adams/ryu
//
// and adapted to clazezs.org coding styles in line with the formatted interface
// of the java.text APIs.
//
// Original copyright below.

// Copyright 2018 Ulf Adams
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.clazzes.util.ryu;

public enum RoundingMode {
    CONSERVATIVE {
        @Override
        public boolean acceptUpperBound(boolean even) {
            return false;
        }

        @Override
        public boolean acceptLowerBound(boolean even) {
            return false;
        }
    },
    ROUND_EVEN {
        @Override
        public boolean acceptUpperBound(boolean even) {
            return even;
        }

        @Override
        public boolean acceptLowerBound(boolean even) {
            return even;
        }
    };

    public abstract boolean acceptUpperBound(boolean even);
    public abstract boolean acceptLowerBound(boolean even);
}
