/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 2006-12-27
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.lang;

import java.io.Serializable;

/**
 * @author wglas
 * 
 *         A trio of three java objects, implemented as a Java 1.5 generic. The
 *         lack of this type is actually a bug of JRE 1.5
 */

public class Triple<A, B, C> implements Serializable
{
    private static final long serialVersionUID = -3985713729332106814L;

    A first;

    B second;
    
    C third;

    /**
     * Contructs a triple holding two null values.
     */
    public Triple() {
        super();
        this.first = null;
        this.second = null;
        this.third = null;
    }

    /**
     * Contructs a triple holding the given objects.
     */
    public Triple(A a, B b, C c) {
        super();
        this.first = a;
        this.second = b;
        this.third = c;
    }

    /**
     * Contructs a triple holding the objects of the given pair.
     */
    public Triple(Triple<A, B, C> p) {
        super();
        this.first = p.getFirst();
        this.second = p.getSecond();
        this.third = p.getThird();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Triple))
            return false;

        Triple p = (Triple) o;
        if (this.first == null) {
            if (p.getFirst() != null)
                return false;
        } else {
            if (!this.first.equals(p.getFirst()))
                return false;
        }
        if (this.second == null) {
            if (p.getSecond() != null)
                return false;
        } else {
            if (!this.second.equals(p.getSecond()))
                return false;
        }
        if (this.third == null) {
            return p.getThird() == null;
        } else {
            return this.third.equals(p.getThird());
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        // obey the following rules:
        // Triple(null,null,null).hashCode() = -1;
        // Triple(a,b,null).hashCode() = a.hashCode() ^ b.hashCode() ^ -3;
        // Triple(a,null,c).hashCode() = a.hashCode() ^ -2 ^ c.hashCode();
        // Triple(null,b,c).hashCode() = -1 ^ b.hashCode() ^ c.hashCode();
        // Triple(a,b,c).hashCode() = a.hashCode() ^ b.hashCode() ^
        // c.hashCode();
        int ret;
        ret = (this.first == null ? -1 : this.first.hashCode());
        ret ^= (this.second == null ? -2 : this.second.hashCode());
        ret ^= (this.third == null ? -3 : this.third.hashCode());
        return ret;
    }

    @Override
    public String toString() {
        return "Triple(" + this.first + ", " + this.second + ", "
                + this.third + ")";
    }

    /**
     * @return Returns the first object.
     */
    public A getFirst() {
        return this.first;
    }

    /**
     * @param first
     *            The first object to set.
     */
    public void setFirst(A first) {
        this.first = first;
    }

    /**
     * @return Returns the second object.
     */
    public B getSecond() {
        return this.second;
    }

    /**
     * @param second
     *            The second objet to set.
     */
    public void setSecond(B second) {
        this.second = second;
    }

    /**
     * @return the third
     */
    public C getThird() {
        return this.third;
    }

    /**
     * @param third
     *            the third to set
     */
    public void setThird(C third) {
        this.third = third;
    }

}
