/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 2006-12-27
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.lang;

import java.io.Serializable;

/**
 * @author wglas
 * 
 *         A pair of two java objects, implemented as a Java 1.5 generic. The
 *         lack of this type is actually a bug of JRE 1.5
 */

public class Pair<A, B> implements Serializable
{
    private static final long serialVersionUID = -1521005356352654931L;

    A first;

    B second;

    /**
     * Contructs a pair holding two null values.
     */
    public Pair() {
        super();
        this.first = null;
        this.second = null;
    }

    /**
     * Contructs a pair holding the given objects.
     */
    public Pair(A a, B b) {
        super();
        this.first = a;
        this.second = b;
    }

    /**
     * Contructs a pair holding the objects of the given pair.
     */
    public Pair(Pair<A, B> p) {
        super();
        this.first = p.getFirst();
        this.second = p.getSecond();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Pair))
            return false;

        Pair p = (Pair) o;

        if (this.first == null) {
            if (p.getFirst() != null)
                return false;
        } else {
            if (!this.first.equals(p.getFirst()))
                return false;
        }
        if (this.second == null) {
            return p.getSecond() == null;
        } else {
            return this.second.equals(p.getSecond());
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        // obey the following rules:
        // Pair(null,null).hashCode() = -1;
        // Pair(a,null).hashCode() = a.hashCode();
        // Pair(null,b).hashCode() = -1 ^ b.hashCode();
        // Pair(a,b).hashCode() = a.hashCode() ^ b.hashCode();
        int ret = -1;
        if (this.first != null)
            ret = this.first.hashCode();
        if (this.second != null)
            ret ^= this.second.hashCode();
        return ret;
    }

    @Override
    public String toString() {
        
        return "Pair("+this.first+", "+this.second+")";
    }
    
    /**
     * @return Returns the first object.
     */
    public A getFirst() {
        return this.first;
    }

    /**
     * @param first
     *            The first object to set.
     */
    public void setFirst(A first) {
        this.first = first;
    }

    /**
     * @return Returns the second object.
     */
    public B getSecond() {
        return this.second;
    }

    /**
     * @param second
     *            The second objet to set.
     */
    public void setSecond(B second) {
        this.second = second;
    }

}
