package org.clazzes.util.lang;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;

public class MappedSet<V,VM> extends AbstractSet<VM> {
    private final Set<V> underlying;
    private final Function<V,VM> mapper;
    private final Function<Object,Object> reverseMapper;

    public MappedSet(Set<V> underlying, Function<V, VM> mapper, Function<Object, Object> reverseMapper) {
        this.underlying = underlying;
        this.mapper = mapper;
        this.reverseMapper = reverseMapper;

    }

    @Override
    public Iterator<VM> iterator() {
        return MappedIterator.newInstance(this.underlying.iterator(), this.mapper);
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

	@Override
	public boolean contains(Object o) {
        return this.underlying.contains(this.reverseMapper.apply(o));
	}

    public static <V,VM> MappedSet<V,VM> newInstance(Set<V> underlying, Function<V, VM> mapper, Function<Object, Object> reverseMapper) {
        return new MappedSet<V,VM>(underlying,mapper,reverseMapper);
    }
}
