package org.clazzes.util.lang;

import java.util.Iterator;
import java.util.function.Function;

public class MappedIterator<P, T> implements Iterator<T> {
    private Iterator<P> underlying;
    private Function<P, T> mapper;

    public MappedIterator(Iterator<P> underlying, Function<P, T> mapper) {
        this.underlying = underlying;
        this.mapper = mapper;
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public T next() {
        return this.mapper.apply(this.underlying.next());
    }

    public static <P, T> MappedIterator<P, T> newInstance(Iterator<P> underlying, Function<P, T> mapper) {
        return new MappedIterator<P, T>(underlying, mapper);
    };
}
