/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 29 Apr 2009
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.lang;

/**
 * @author jpayr
 *
 */
public class ComparableTriple<A extends Comparable<A>, B extends Comparable<B>, C extends Comparable<C>> extends Triple<A, B, C> implements Comparable<ComparableTriple<A, B, C>> {

    private static final long serialVersionUID = 2009060601L;

    public int compareTo(ComparableTriple<A, B, C> o) {
        
        if (o != null) {
            int resA = Util.compareNullAware(this.getFirst(),o.getFirst());
            
            if (resA == 0) {
                
                int resB = Util.compareNullAware(this.getSecond(),o.getSecond());
                
                if (resB == 0) {
                    return Util.compareNullAware(this.getThird(),o.getThird());
                }
                return resB;
            }
            return resA;
        }
        throw new ClassCastException("Cannot compare null with ComparableTriple");
    }

    /**
     * 
     */
    public ComparableTriple() {
        super();
    }

    /**
     * @param a
     * @param b
     * @param c
     */
    public ComparableTriple(A a, B b, C c) {
        super(a, b, c);
    }

    /**
     * @param p
     */
    public ComparableTriple(Triple<A, B, C> p) {
        super(p);
    }

}
