/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 21 Apr 2009
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.lang;

/**
 * A pair, which is comparable with a precedence for <code>first</code>.
 */
public class ComparablePair<A extends Comparable<A>, B extends Comparable<B>> extends Pair<A, B> implements Comparable<ComparablePair<A, B>> {

    private static final long serialVersionUID = 2009060601L;

    public int compareTo(ComparablePair<A, B> o) {
        if (o != null) {
                
            int resA = Util.compareNullAware(this.getFirst(),o.getFirst());
            
            if (resA == 0) {
                return Util.compareNullAware(this.getSecond(),o.getSecond());
            }
            else {
                return resA;
            }
        }
        throw new ClassCastException("Cannot compare null with ComparablePair");
    }

    /**
     * 
     */
    public ComparablePair() {
        super();
    }

    /**
     * @param a
     * @param b
     */
    public ComparablePair(A a, B b) {
        super(a, b);
    }

    /**
     * @param p
     */
    public ComparablePair(Pair<A, B> p) {
        super(p);
    }

}
