/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 30.10.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.formula.ast;

/**
 * Base class for unary nodes.
 */
public abstract class UnaryOpFormulaNode extends FormulaNode {

    private static final long serialVersionUID = 2565312409937642220L;

    private final FormulaNode rhs;
    
    /**
     * @param rhs The right-hand side expression.
     */
    public UnaryOpFormulaNode(FormulaNode rhs) {
        this.rhs = rhs;
    }

    public FormulaNode getRhs() {
        return this.rhs;
    }
}
