/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 30.10.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.formula.ast;

import org.clazzes.util.formula.SymbolValues;

/**
 * A symbolic value inside a formula.
 */
public class SymbolFormulaNode extends FormulaNode {

    private static final long serialVersionUID = -2861465449256432043L;

    private final String symbol;
    
    /**
     * @param symbol The symbol addressed by this node.
     */
    public SymbolFormulaNode(String symbol) {
        super();
        this.symbol = symbol;
    }

    @Override
    public String getOperator() {
        
        return null;
    }

    @Override
    public int getPrecedence() {
        
        return -1;
    }

    @Override
    public double evaluate(SymbolValues symbols) {
        
        Number v = symbols == null ? null : symbols.getSymbolValue(this.symbol);
        
        if (v == null) {
            throw new IllegalArgumentException("Symbol ["+this.symbol+"] not known in formula evauation.");
        }
        
        return v.doubleValue();
    }

    @Override
    public void accept(FormulaNodeVisitor visitor) {
        
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return this.symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }
    
}
