/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 30.10.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.formula.ast;

import org.clazzes.util.formula.FormulaHelper;
import org.clazzes.util.formula.SymbolValues;

/**
 * Logical less than or equals operation.
 */
public class LeqFormulaNode extends BinaryOpFormulaNode {

    private static final long serialVersionUID = -634565142651241228L;

    /**
     * @param lhs The left-hand side.
     * @param rhs The right-hand side.
     */
    public LeqFormulaNode(FormulaNode lhs, FormulaNode rhs) {
        super(lhs, rhs);
    }

    @Override
    public String getOperator() {
        return "<=";
    }

    @Override
    public int getPrecedence() {
        
        return 5;
    }

    @Override
    public double evaluate(SymbolValues symbols) {
        
        return FormulaHelper.booleanToDouble(this.getLhs().evaluate(symbols) <= this.getRhs().evaluate(symbols));
    }

    @Override
    public void accept(FormulaNodeVisitor visitor) {
        visitor.visit(this);
    }

}
