/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 30.10.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.formula.ast;

import org.clazzes.util.formula.FormulaHelper;
import org.clazzes.util.formula.SymbolValues;

/**
 * Function evaluation operation.
 */
public class FunctionFormulaNode extends UnaryOpFormulaNode {

    private static final long serialVersionUID = -2356820985554504221L;
    
    final String f;
    
    /**
     * @param f A builtin function name.
     * @param rhs The right-hand side.
     * @see FormulaHelper#callBuiltin(String, double)
     */
    public FunctionFormulaNode(String f, FormulaNode rhs) {
        super(rhs);
        this.f = f;
    }

    @Override
    public String getOperator() {
        return this.f;
    }

    @Override
    public int getPrecedence() {
        
        return 10;
    }

    @Override
    public double evaluate(SymbolValues symbols) {
        
        return FormulaHelper.callBuiltin(this.f,this.getRhs().evaluate(symbols));
    }

    @Override
    public String toString() {
        return "["+this.f+","+this.getRhs()+"]";
    }
    
    @Override
    public void accept(FormulaNodeVisitor visitor) {
        visitor.visit(this);
    }

}
