/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 23.02.2011
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.formula;

import java.text.ParseException;

/**
 * An implementation of this interface is provided to
 * {@link FormulaEvaluator} in order to retrieve the values of
 * symbolic placeholders.
 */
public interface SymbolValues {

    /**
     * Get the numeric value of a given symbolic placeholder.
     * @param sym The name of the placeholder.
     * @return The current value of the placeholder or <code>null</code>,
     *         if the placeholder is unknown and {@link FormulaEvaluator}
     *         should throw a {@link ParseException}.
     */
    Number getSymbolValue(String sym);
}
