/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 02.11.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.formula;

/**
 * options for the formula parser passed as ORed bitmask.
 */
public interface FormulaOptions {

    /**
     * Default options, C-style builtin  functions, not dots or brackets in identifiers.
     */
    public static final int DEFAULT = 0;

    /**
     * Use <code>ln</code> instead of <code>log</code>,
     * <code>log</code> instead of <code>log10</code> and
     * <code>sgn</code> instead of <code>signum</code>.
     */
    public static final int LEGACY_BUILTINS = 1 << 0;
    
    /**
     * Allow identifiers, which contain dot character.
     */
    public static final int DOT_IDENTIFIERS = 1 << 1;
    
    /**
     * Allow identifiers, which contain an opening and a closing brackets.
     */
    public static final int BRACKET_IDENTIFIERS = 1 << 2;
    
}
