/***********************************************************
 * $Id$
 * 
 * Utility classes of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 2006-03-13
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.annotations;

import java.lang.annotation.Documented;

/**
 * This annotation holds a translatable string mostly
 * used by another annotations.
 * 
 * @author wglas
 */
@Documented
public @interface I18N
{
	/**
	 * @return The translatable string. This string is not actually translated,
	 *         this annotation is just a marker for classes using annotations
	 *         in order to extract the string to the list of translatable strings.
	 */
	String value();
}
