/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.config.keys.AuthorizedKeysAuthenticator;
import org.apache.sshd.server.shell.ShellFactory;
import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ConfigWrapper;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.CoreService;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServicePriority;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.svc.api.cmd.CommandSet;
import org.clazzes.svc.runner.sshd.ExternalCommandResolver;
import org.clazzes.svc.runner.sshd.GogoCommandResolver;
import org.clazzes.svc.runner.sshd.GogoSshHandler;
import org.clazzes.svc.runner.sshd.HostKeyGenerator;
import org.clazzes.svc.runner.sshd.ListResolver;
import org.clazzes.svc.runner.sshd.cmd.SvcCommands;
import org.jline.builtins.ssh.ShellCommand;
import org.jline.builtins.ssh.ShellFactoryImpl;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServicePriority(value=8)
public class SshdComponent
implements Component {
    public static final String PID = "org.clazzes.svc.runner.sshd";
    private static final Logger log = LoggerFactory.getLogger(SshdComponent.class);
    private ExecutorService executorService;
    private SshServer sshServer;

    public void start(ServiceContext svcCtxt) throws Exception {
        Path sshdEtcDir;
        CoreService coreService = (CoreService)svcCtxt.getService(CoreService.class).get();
        ServiceRegistry registry = (ServiceRegistry)svcCtxt.getService(ServiceRegistry.class).get();
        ConfigurationEngine confEngine = (ConfigurationEngine)svcCtxt.getService(ConfigurationEngine.class).get();
        ComponentManager componentManager = (ComponentManager)svcCtxt.getService(ComponentManager.class).get();
        Path etcDir = coreService.getEtcDir();
        if (etcDir == null) {
            log.warn("Will not start svc-runner SSHD service in Unit Test mode.");
            sshdEtcDir = null;
        } else {
            sshdEtcDir = etcDir.resolve("sshd.d");
        }
        confEngine.listen(PID, config -> {
            this.stopSshServer();
            this.startSshServer(svcCtxt, sshdEtcDir, (ConfigWrapper)config, registry);
            componentManager.commit();
        });
    }

    public void stop(ServiceContext svcCtxt) throws Exception {
        this.stopSshServer();
    }

    private synchronized void startSshServer(ServiceContext svcCtxt, Path etcPathObj, ConfigWrapper config, ServiceRegistry registry) {
        block31: {
            Path keyFile;
            if (this.sshServer != null) {
                if (log.isDebugEnabled()) {
                    log.debug("GoGo SSH Server already started.");
                }
                return;
            }
            SshServer sshd = SshServer.setUpDefaultServer();
            int port = config.getInt("port", 8108);
            sshd.setPort(port);
            int timeout = config.getInt("timeout", 600000);
            sshd.getProperties().put(CoreModuleProperties.IDLE_TIMEOUT.getName(), timeout);
            String host = config.getString("host", "127.0.0.1").trim();
            if (!host.isEmpty() && !"*".equals(host)) {
                sshd.setHost(host);
            }
            sshd.setCipherFactories(Arrays.asList(BuiltinCiphers.cc20p1305_openssh, BuiltinCiphers.aes256ctr, BuiltinCiphers.aes192ctr, BuiltinCiphers.aes128ctr, BuiltinCiphers.aes256gcm, BuiltinCiphers.aes128gcm));
            if (log.isDebugEnabled()) {
                log.debug("GoGo SSH Server's etcPath resolved to [{}].", (Object)etcPathObj);
            }
            sshd.setPublickeyAuthenticator((PublickeyAuthenticator)new AuthorizedKeysAuthenticator(etcPathObj.resolve("authorized_keys")));
            String algo = config.getString("hostKeyAlgorithm", "EdDSA");
            if ("RSA".equals(algo)) {
                keyFile = etcPathObj.resolve("ssh_host_rsa_key");
            } else if ("EdDSA".equals(algo)) {
                keyFile = etcPathObj.resolve("ssh_host_ed25519_key");
            } else if ("EC".equals(algo)) {
                keyFile = etcPathObj.resolve("ssh_host_ecdsa_key");
            } else {
                log.error("Error starting GoGo SSH Server on address [" + host + ":" + port + "], ssh key algorithm [" + algo + "] is not supported.");
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("keyFile = {}", (Object)keyFile);
                log.debug("Files.exists(keyFile) = {}", (Object)Files.exists(keyFile, new LinkOption[0]));
            }
            if (!Files.exists(keyFile, new LinkOption[0])) {
                log.info("Key File [{}] does not exist, trying to generate the host key.", (Object)keyFile);
                if ("RSA".equals(algo)) {
                    keySize = config.getInt("hostKeySize", 3072);
                    try {
                        HostKeyGenerator.generateRSAHostKey(keyFile, keySize);
                    }
                    catch (Exception e) {
                        log.error("Error generating RSA host key", (Throwable)e);
                        return;
                    }
                } else if ("EdDSA".equals(algo)) {
                    keySize = config.getInt("hostKeySize", 256);
                    try {
                        HostKeyGenerator.generateEdDSAHostKey(keyFile, keySize);
                    }
                    catch (Exception e) {
                        log.error("Error generating EdDSA host key", (Throwable)e);
                        return;
                    }
                } else if ("EC".equals(algo)) {
                    keySize = config.getInt("hostKeySize", 256);
                    try {
                        HostKeyGenerator.generateECDSAHostKey(keyFile, keySize);
                    }
                    catch (Exception e) {
                        log.error("Error generating ECDSA host key", (Throwable)e);
                        return;
                    }
                } else {
                    log.error("Error starting GoGo SSH Server on address [" + host + ":" + port + "], ssh key for algorithm [" + algo + "] cannot be generated.");
                    return;
                }
            }
            log.info("Loading {} key file [{}]", (Object)algo, (Object)keyFile);
            FileKeyPairProvider kpp = new FileKeyPairProvider(keyFile);
            sshd.setKeyPairProvider((KeyPairProvider)kpp);
            ExecutorService es = null;
            try {
                es = Executors.newCachedThreadPool(r -> new Thread(r, "svc-runner-sshd"));
                Module module = SshdComponent.class.getModule();
                GogoSshHandler handler = new GogoSshHandler();
                handler.setExecutor(es);
                handler.setVersion(module.getDescriptor().version().get().toString());
                GogoCommandResolver dynamicResolver = new GogoCommandResolver();
                dynamicResolver.setGetCommandSets(() -> registry.getAll(CommandSet.class));
                GogoCommandResolver builtinResolver = new GogoCommandResolver();
                Map<String, SvcCommands> builtinCommandSets = Map.of("svc", new SvcCommands(svcCtxt));
                builtinResolver.setGetCommandSets(() -> builtinCommandSets);
                ExternalCommandResolver externalResolver = new ExternalCommandResolver();
                externalResolver.setExecutor(es);
                handler.setResolver(new ListResolver(List.of(dynamicResolver, builtinResolver, externalResolver)));
                IllegalStateException iav = new IllegalStateException("jline3");
                List providers = TerminalBuilder.builder().getProviders(null, iav);
                List providerNames = providers.stream().map(p -> p.name()).collect(Collectors.toList());
                log.info("Available jline3 terminal providers are {}", providerNames);
                Throwable[] supp = iav.getSuppressed();
                if (supp != null && supp.length > 0) {
                    StringBuilder summary = new StringBuilder();
                    int i = 0;
                    while (i < supp.length) {
                        Throwable sup = supp[i++];
                        summary.append("\n  jline3 err #").append(i).append(": ");
                        summary.append(sup.toString());
                    }
                    log.warn("[{}] jline3 terminal providers did not load:{}", (Object)supp.length, (Object)summary);
                    if (log.isDebugEnabled()) {
                        log.debug("jline3 TerminalProvider load error details:", (Throwable)iav);
                    }
                }
                ShellFactoryImpl shellFactory = new ShellFactoryImpl(handler.interactiveHandler());
                sshd.setShellFactory((ShellFactory)shellFactory);
                sshd.setCommandFactory((channel, command) -> new ShellCommand(handler.executeHandler(), command));
                if (log.isInfoEnabled()) {
                    log.info("Starting GoGo SSH Server on address [" + host + ":" + port + "]...");
                }
                sshd.start();
                this.sshServer = sshd;
                this.executorService = es;
                if (log.isInfoEnabled()) {
                    log.info("Successfully started GoGo SSH Server on address [" + host + ":" + port + "].");
                }
            }
            catch (Throwable e) {
                log.error("Error starting GoGo SSH Server on address [" + host + ":" + port + "]", e);
                if (es == null) break block31;
                es.shutdownNow();
            }
        }
    }

    private synchronized void stopSshServer() {
        if (this.sshServer != null) {
            SshServer sshd = this.sshServer;
            this.sshServer = null;
            try {
                if (log.isInfoEnabled()) {
                    log.info("Stopping GoGo SSH Server on address [" + sshd.getHost() + ":" + sshd.getPort() + "]...");
                }
                sshd.stop();
                if (log.isInfoEnabled()) {
                    log.info("Successfully stopped GoGo SSH Server on address [" + sshd.getHost() + ":" + sshd.getPort() + "].");
                }
            }
            catch (Exception e) {
                log.warn("Error stopping GoGo SSH Server on address [" + sshd.getHost() + ":" + sshd.getPort() + "]", (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("GoGo SSH Server already stopped.");
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }
}

