/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.clazzes.svc.runner.sshd.CliCommand;
import org.clazzes.svc.runner.sshd.CommandEnvironment;
import org.clazzes.svc.runner.sshd.CommandInfo;
import org.clazzes.svc.runner.sshd.CommandParameters;
import org.clazzes.svc.runner.sshd.CommandParser;
import org.clazzes.svc.runner.sshd.CommandResolver;
import org.clazzes.svc.runner.sshd.ExceptionFnUtil;
import org.clazzes.svc.runner.sshd.ListResolver;
import org.clazzes.svc.runner.sshd.PosixFileDescriptor;
import org.clazzes.svc.runner.sshd.ShellExitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellExecutionEngine
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ShellExecutionEngine.class);
    private final ExecutorService executor;
    private final CommandResolver commandResolver;
    private final Subshell mainSubshell;
    private static final Map.Entry<Function<Subshell, CliCommand>, String> exitEntry = Map.entry(subshell -> subshell::builtinExit, "Exit this shell");
    private static final Map<String, Map.Entry<Function<Subshell, CliCommand>, String>> builtins = Map.of("help", Map.entry(subshell -> subshell::builtinHelp, "Print a list of available commands"), "exit", exitEntry, "quit", exitEntry, "logout", exitEntry, ":q!", exitEntry, ":q", exitEntry, ":wq", exitEntry);

    public ShellExecutionEngine(ExecutorService executor, CommandResolver commandResolver, CommandEnvironment env) {
        this.executor = executor;
        this.commandResolver = commandResolver;
        this.mainSubshell = new Subshell(env);
    }

    private static final Map.Entry<PipedInputStream, PipedOutputStream> pipe() {
        try {
            PipedInputStream input = new PipedInputStream();
            PipedOutputStream output = new PipedOutputStream(input);
            return Map.entry(input, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final int waitOnSubshellFuture(Future<Integer> fut) {
        while (true) {
            try {
                return fut.get();
            }
            catch (InterruptedException e) {
                fut.cancel(true);
                continue;
            }
            catch (ExecutionException e) {
                log.warn("Unexpected exception in subshell {}", e.getCause());
                return 1;
            }
            break;
        }
    }

    private int executeSubshell(CommandEnvironment env, ToIntFunction<Subshell> executionFunction) {
        Subshell subshell = new Subshell(env);
        try {
            int n = executionFunction.applyAsInt(subshell);
            subshell.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    subshell.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ShellExitException e) {
                return e.getStatus();
            }
            catch (Exception e) {
                log.error("Unexpected exception in subshell", (Throwable)e);
                return 1;
            }
        }
    }

    public int executeCommand(CommandParser.ParsedCommand command) {
        return this.mainSubshell.executeCommand(command);
    }

    public CommandEnvironment getEnv() {
        return this.mainSubshell.env;
    }

    public CommandResolver getResolver() {
        return this.mainSubshell.subshellResolver;
    }

    public Optional<String> expandWordWithoutSideEffects(CommandParser.Word word) {
        try {
            return Optional.of(this.mainSubshell.expandWord(word, false));
        }
        catch (UnwantedSideEffectException e) {
            return Optional.empty();
        }
    }

    @Override
    public void close() throws IOException {
        this.mainSubshell.close();
    }

    private final class Subshell
    implements Closeable,
    CommandResolver {
        public CommandEnvironment env;
        private List<Future<Integer>> jobs = new ArrayList<Future<Integer>>();
        private CommandResolver subshellResolver;

        @Override
        public CliCommand resolveCommand(String commandName, CommandEnvironment env) {
            Map.Entry<Function<Subshell, CliCommand>, String> builtin = builtins.get(commandName);
            if (builtin == null) {
                return null;
            }
            return builtin.getKey().apply(this);
        }

        @Override
        public List<CommandInfo> listCommands(String commandNamePrefix, CommandEnvironment env) {
            return builtins.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(commandNamePrefix)).map(entry -> new CommandInfo((String)entry.getKey(), (String)((Map.Entry)entry.getValue()).getValue())).toList();
        }

        public Subshell(CommandEnvironment env) {
            this.subshellResolver = new ListResolver(List.of(ShellExecutionEngine.this.commandResolver, this));
            this.env = env;
        }

        private int builtinHelp(CommandParameters params) throws Exception {
            try (PrintWriter writer = params.env().stdoutWriter();){
                if (params.arguments().size() == 2) {
                    if (List.of("-h", "--help").contains(params.arguments().get(1))) {
                        writer.println("Usage: help [-h] [command]\nPrint a list of available commands or print the help of a specific command.\n\n  -h, --help   display this help and exit");
                        int n = 0;
                        return n;
                    }
                    String commandName = params.arguments().get(1);
                    CliCommand resolved = this.subshellResolver.resolveCommand(commandName, this.env);
                    if (resolved == null) {
                        writer.println(commandName + " not found");
                        int n = 1;
                        return n;
                    }
                    int n = resolved.execute(new CommandParameters(params.env(), List.of(commandName, "--help")));
                    return n;
                }
                if (params.arguments().size() == 1) {
                    Iterable commands = () -> this.subshellResolver.listCommands("", params.env()).stream().sorted(Comparator.comparing(CommandInfo::name)).iterator();
                    for (CommandInfo commandInfo : commands) {
                        writer.println(commandInfo.name() + " - " + commandInfo.helpText());
                    }
                    int n = 0;
                    return n;
                }
                writer.println("help: bad usage\nTry 'help --help' for more information.\n");
                int n = 1;
                return n;
            }
        }

        private int builtinExit(CommandParameters params) throws Exception {
            if (params.arguments().size() == 2 && List.of("-h", "--help").contains(params.arguments().get(1))) {
                try (PrintWriter writer = params.env().stdoutWriter();){
                    writer.println("Usage: %s [-h] [status]\nExit this shell with the given status, or 0 if none is given.\n\n  -h, --help   display this help and exit".formatted(params.arguments().get(0)));
                }
                return 0;
            }
            Integer status = null;
            if (params.arguments().size() == 1) {
                status = 0;
            } else if (params.arguments().size() == 2) {
                try {
                    status = Integer.valueOf(params.arguments().get(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (status == null) {
                try (PrintWriter writer = params.env().stdoutWriter();){
                    writer.println("%1$s: bad usage\nTry '%1$s --help' for more information.\n".formatted(params.arguments().get(0)));
                }
                return 1;
            }
            throw new ShellExitException(status);
        }

        private String executeCommandSubstitution(CommandParser.ParsedCommand cmd) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ShellExecutionEngine.this.executeSubshell(this.env.duplicate().withStdout(PosixFileDescriptor.ofOutput(bytes)), subshell -> subshell.executeCommand(cmd));
            return new String(bytes.toByteArray(), StandardCharsets.UTF_8);
        }

        private String expandDoubleQuotedPart(CommandParser.DoubleQuotedPart part, boolean sideEffects) throws Exception {
            if (part instanceof CommandParser.DoubleQuotedPart.QuotedLiteral) {
                CommandParser.DoubleQuotedPart.QuotedLiteral lit = (CommandParser.DoubleQuotedPart.QuotedLiteral)part;
                return lit.str();
            }
            if (part instanceof CommandParser.DoubleQuotedPart.CommandSubstitution) {
                CommandParser.DoubleQuotedPart.CommandSubstitution cmd = (CommandParser.DoubleQuotedPart.CommandSubstitution)part;
                if (!sideEffects) {
                    throw new UnwantedSideEffectException();
                }
                return this.executeCommandSubstitution(cmd.command());
            }
            throw new RuntimeException("Unsupported kind of double quoted part.");
        }

        private String expandWordPart(CommandParser.WordPart part, boolean sideEffects) throws Exception {
            if (part instanceof CommandParser.WordPart.Literal) {
                CommandParser.WordPart.Literal lit = (CommandParser.WordPart.Literal)part;
                return lit.str();
            }
            if (part instanceof CommandParser.WordPart.CommandSubstitution) {
                CommandParser.WordPart.CommandSubstitution cmd = (CommandParser.WordPart.CommandSubstitution)part;
                if (!sideEffects) {
                    throw new UnwantedSideEffectException();
                }
                return this.executeCommandSubstitution(cmd.command());
            }
            if (part instanceof CommandParser.WordPart.DoubleQuoted) {
                CommandParser.WordPart.DoubleQuoted dq = (CommandParser.WordPart.DoubleQuoted)part;
                return dq.parts().stream().map(ExceptionFnUtil.sneakyFn(dqPart -> this.expandDoubleQuotedPart((CommandParser.DoubleQuotedPart)dqPart, sideEffects))).collect(Collectors.joining(""));
            }
            throw new RuntimeException("Unsupported kind of word part.");
        }

        public String expandWord(CommandParser.Word word, boolean sideEffects) {
            return word.parts().stream().map(ExceptionFnUtil.sneakyFn(part -> this.expandWordPart((CommandParser.WordPart)part, sideEffects))).collect(Collectors.joining(""));
        }

        public String expandWord(CommandParser.Word word) {
            return this.expandWord(word, true);
        }

        private PosixFileDescriptor handleFileRedirection(Path filePath, CommandParser.FileRedirectionKind kind) throws IOException {
            return switch (kind) {
                default -> throw new IncompatibleClassChangeError();
                case CommandParser.FileRedirectionKind.APPEND -> PosixFileDescriptor.ofOutput(Files.newOutputStream(filePath, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE));
                case CommandParser.FileRedirectionKind.OUTPUT, CommandParser.FileRedirectionKind.OUTPUT_FORCE_CLOBBER -> PosixFileDescriptor.ofOutput(Files.newOutputStream(filePath, new OpenOption[0]));
                case CommandParser.FileRedirectionKind.INPUT -> PosixFileDescriptor.ofInput(Files.newInputStream(filePath, new OpenOption[0]));
            };
        }

        public PosixFileDescriptor handleRedirection(CommandParser.RedirectionKind kind) throws IOException {
            if (kind instanceof CommandParser.RedirectionKind.HereDocument) {
                CommandParser.RedirectionKind.HereDocument hereDoc = (CommandParser.RedirectionKind.HereDocument)kind;
                return PosixFileDescriptor.ofInput(new ByteArrayInputStream(hereDoc.document().getBytes(StandardCharsets.UTF_8)));
            }
            if (kind instanceof CommandParser.RedirectionKind.Duplicate) {
                CommandParser.RedirectionKind.Duplicate dup = (CommandParser.RedirectionKind.Duplicate)kind;
                Integer prevFdNumber = Integer.valueOf(this.expandWord(dup.duplicatedFd()));
                PosixFileDescriptor prev = this.env.fds().get(prevFdNumber);
                if (prev == null) {
                    throw new RuntimeException("bad file descriptor");
                }
                return (switch (dup.kind()) {
                    default -> throw new IncompatibleClassChangeError();
                    case CommandParser.DuplicateKind.INPUT -> prev.onlyInput();
                    case CommandParser.DuplicateKind.OUTPUT -> prev.onlyOutput();
                    case CommandParser.DuplicateKind.BOTH -> prev;
                }).duplicate();
            }
            if (kind instanceof CommandParser.RedirectionKind.File) {
                CommandParser.RedirectionKind.File file = (CommandParser.RedirectionKind.File)kind;
                Path filePath = Paths.get(this.env.cwd(), new String[0]).resolve(this.expandWord(file.word()));
                return this.handleFileRedirection(filePath, file.kind());
            }
            throw new RuntimeException("unsupported kind of redirection");
        }

        public int executeSimple(CommandParser.Command.Simple simple) {
            String mainWordExpanded = this.expandWord(simple.mainWord());
            List<String> argv = Stream.concat(Stream.of(mainWordExpanded), simple.otherWords().stream().map(ExceptionFnUtil.sneakyFn(this::expandWord))).toList();
            HashMap<String, String> newEnvVars = new HashMap<String, String>(this.env.envVars());
            for (CommandParser.AssignmentWord assignmentWord : simple.assignments()) {
                newEnvVars.put(assignmentWord.key(), this.expandWord(assignmentWord.value()));
            }
            HashMap<Integer, PosixFileDescriptor> newFds = new HashMap<Integer, PosixFileDescriptor>(this.env.duplicate().fds());
            try {
                for (CommandParser.Redirection redirection : simple.redirections()) {
                    PosixFileDescriptor newFd = this.handleRedirection(redirection.kind());
                    PosixFileDescriptor prevFd = this.env.fds().get(redirection.fd());
                    if (prevFd != null) {
                        prevFd.close();
                    }
                    newFds.put(redirection.fd(), newFd);
                }
            }
            catch (Exception exception) {
                for (PosixFileDescriptor newFd : newFds.values()) {
                    newFd.close();
                }
                try {
                    this.env.stderr().write(("osgi-shell: " + exception.getMessage() + "\n").getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e1) {
                    log.warn("Unable to write error message", (Throwable)e1);
                }
                return 1;
            }
            try (CommandEnvironment commandEnvironment = new CommandEnvironment(newEnvVars, newFds, this.env.cwd());){
                CliCommand resolved = this.subshellResolver.resolveCommand(mainWordExpanded, commandEnvironment);
                if (resolved == null) {
                    try {
                        commandEnvironment.stderr().write(("osgi-shell: command not found: " + mainWordExpanded + "\n").getBytes(StandardCharsets.UTF_8));
                    }
                    catch (IOException e1) {
                        log.warn("Unable to write error message", (Throwable)e1);
                    }
                    int e1 = 127;
                    return e1;
                }
                int e1 = resolved.execute(new CommandParameters(commandEnvironment, argv));
                return e1;
            }
        }

        public int executeCommand(CommandParser.Command command) {
            if (command instanceof CommandParser.Command.Simple) {
                CommandParser.Command.Simple simple = (CommandParser.Command.Simple)command;
                return this.executeSimple(simple);
            }
            throw new RuntimeException("Unsupported kind of command.");
        }

        public int executePipeline(CommandParser.Pipeline pipeline) {
            assert (pipeline.commands().size() > 0);
            if (pipeline.commands().size() == 1) {
                return this.executeCommand(pipeline.commands().get(0));
            }
            ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
            PosixFileDescriptor currentPipeInput = this.env.fds().get(0);
            List<CommandParser.Command> firstCommands = pipeline.commands().subList(0, pipeline.commands().size() - 1);
            for (CommandParser.Command command : firstCommands) {
                Map.Entry<PipedInputStream, PipedOutputStream> pipe = ShellExecutionEngine.pipe();
                CommandEnvironment fork = this.env.duplicate().withStdin(currentPipeInput).withStdout(PosixFileDescriptor.ofOutput(pipe.getValue()));
                futures.add(ShellExecutionEngine.this.executor.submit(() -> ShellExecutionEngine.this.executeSubshell(fork, subshell -> subshell.executeCommand(command))));
                currentPipeInput = PosixFileDescriptor.ofInput(pipe.getKey());
            }
            CommandEnvironment lastFork = this.env.duplicate().withStdin(currentPipeInput);
            CommandParser.Command lastCommand = pipeline.commands().get(pipeline.commands().size() - 1);
            Future<Integer> lastFuture = ShellExecutionEngine.this.executor.submit(() -> ShellExecutionEngine.this.executeSubshell(lastFork, subshell -> subshell.executeCommand(lastCommand)));
            int ret = ShellExecutionEngine.waitOnSubshellFuture(lastFuture);
            for (Future future : futures) {
                ShellExecutionEngine.waitOnSubshellFuture(future);
            }
            return ret;
        }

        public int executeAndOr(CommandParser.AndOr andOr) {
            int lastStatus = this.executePipeline(andOr.firstPipeline());
            for (CommandParser.AndOrElement element : andOr.elements()) {
                if (element.mode() == CommandParser.AndOrMode.AND) {
                    if (lastStatus != 0) continue;
                    lastStatus = this.executePipeline(element.pipeline());
                    continue;
                }
                if (lastStatus == 0) continue;
                lastStatus = this.executePipeline(element.pipeline());
            }
            return lastStatus;
        }

        public int executeCommand(CommandParser.ParsedCommand command) {
            int lastStatus = 0;
            for (CommandParser.PosixListElement element : command.list()) {
                if (element.mode() == CommandParser.SyncMode.ASYNC) {
                    CommandEnvironment fork = this.env.duplicate();
                    this.jobs.add(ShellExecutionEngine.this.executor.submit(() -> ShellExecutionEngine.this.executeSubshell(fork, subshell -> subshell.executeAndOr(element.andOr()))));
                    lastStatus = 0;
                    continue;
                }
                lastStatus = this.executeAndOr(element.andOr());
            }
            return lastStatus;
        }

        @Override
        public void close() {
            this.env.close();
        }
    }

    private final class UnwantedSideEffectException
    extends RuntimeException {
    }
}

