/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.clazzes.svc.runner.sshd.RefCountedInputStream;
import org.clazzes.svc.runner.sshd.RefCountedOutputStream;
import org.jline.terminal.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record PosixFileDescriptor(RefCountedInputStream in, RefCountedOutputStream out, Terminal terminal) implements Closeable
{
    private static final Logger log = LoggerFactory.getLogger(PosixFileDescriptor.class);

    public static PosixFileDescriptor ofInput(InputStream in) {
        return new PosixFileDescriptor(new RefCountedInputStream(in), null, null);
    }

    public static PosixFileDescriptor ofOutput(OutputStream out) {
        return new PosixFileDescriptor(null, new RefCountedOutputStream(out), null);
    }

    public static PosixFileDescriptor ofTerminal(Terminal terminal) {
        return new PosixFileDescriptor(new RefCountedInputStream(terminal.input()), new RefCountedOutputStream(terminal.output()), terminal);
    }

    public PosixFileDescriptor duplicate() {
        return new PosixFileDescriptor(this.in == null ? null : new RefCountedInputStream(this.in), this.out == null ? null : new RefCountedOutputStream(this.out), this.terminal);
    }

    public PosixFileDescriptor onlyInput() {
        return new PosixFileDescriptor(this.in, null, this.terminal);
    }

    public PosixFileDescriptor onlyOutput() {
        return new PosixFileDescriptor(null, this.out, this.terminal);
    }

    @Override
    public void close() {
        if (this.in != null) {
            log.debug("Closing in {}", (Object)this.in);
            try {
                this.in.close();
            }
            catch (IOException e) {
                log.warn("Unable to close {}", (Object)this.in, (Object)e);
            }
        }
        if (this.out != null) {
            log.debug("Closing out {}", (Object)this.out);
            try {
                this.out.close();
            }
            catch (IOException e) {
                log.warn("Unable to close {}", (Object)this.out, (Object)e);
            }
        }
    }
}

