/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.i2p.crypto.eddsa.spec.EdDSAGenParameterSpec;
import org.apache.sshd.common.config.keys.writer.openssh.OpenSSHKeyPairResourceWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HostKeyGenerator {
    private static final Logger log = LoggerFactory.getLogger(HostKeyGenerator.class);

    protected static String makeComment() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return "gogo-ssh-" + df.format(new Date());
    }

    protected static void writePivateKey(KeyPair kp, String comment, Path file) throws Exception {
        OpenSSHKeyPairResourceWriter osshkprw = new OpenSSHKeyPairResourceWriter();
        osshkprw.writePrivateKey(kp, comment, null, Files.newOutputStream(file, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE));
        PosixFileAttributeView posix = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]);
        if (posix != null) {
            posix.setPermissions(PosixFilePermissions.fromString("r--r-----"));
        } else {
            DosFileAttributeView dos = Files.getFileAttributeView(file, DosFileAttributeView.class, new LinkOption[0]);
            if (dos != null) {
                dos.setReadOnly(true);
            }
        }
    }

    public static String generateECDSAHostKey(Path file, int keySize) throws Exception {
        String comment = HostKeyGenerator.makeComment();
        String algorithm = switch (keySize) {
            case 256 -> "secp256r1";
            case 384 -> "secp384r1";
            case 521 -> "secp521r1";
            default -> throw new IllegalArgumentException("EC key size [" + keySize + "] is not in the set {256, 384, 521}.");
        };
        log.info("Generating [{}] ECDSA host key with comment [{}]...", (Object)algorithm, (Object)comment);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
        kpg.initialize(new ECGenParameterSpec(algorithm));
        KeyPair kp = kpg.generateKeyPair();
        log.info("Writing ECDSA host key with comment [{}] to [{}].", (Object)comment, (Object)file);
        HostKeyGenerator.writePivateKey(kp, comment, file);
        return comment;
    }

    public static String generateEdDSAHostKey(Path file, int keySize) throws Exception {
        String comment = HostKeyGenerator.makeComment();
        String algorithm = switch (keySize) {
            case 256 -> "Ed25519";
            default -> throw new IllegalArgumentException("EdEC key size [" + keySize + "] is not 256.");
        };
        log.info("Generating [{}] ECDSA host key with comment [{}]...", (Object)algorithm, (Object)comment);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EdDSA", "EdDSA");
        kpg.initialize((AlgorithmParameterSpec)new EdDSAGenParameterSpec(algorithm));
        KeyPair kp = kpg.generateKeyPair();
        log.info("Writing EdDSA host key with comment [{}] to [{}].", (Object)comment, (Object)file);
        HostKeyGenerator.writePivateKey(kp, comment, file);
        return comment;
    }

    public static String generateRSAHostKey(Path file, int keySize) throws Exception {
        if (keySize < 2048 || keySize > 8192) {
            throw new IllegalArgumentException("RSA key size [" + keySize + "] is not in the range [2048, 8192].");
        }
        String comment = HostKeyGenerator.makeComment();
        log.info("Generating RSA-{} host key with comment [{}]...", (Object)keySize, (Object)comment);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(keySize);
        KeyPair kp = kpg.generateKeyPair();
        log.info("Writing RSA host key with comment [{}] to [{}].", (Object)comment, (Object)file);
        HostKeyGenerator.writePivateKey(kp, comment, file);
        return comment;
    }
}

