/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import jdk.nio.Channels;
import org.clazzes.svc.runner.sshd.CliCommand;
import org.clazzes.svc.runner.sshd.CommandEnvironment;
import org.clazzes.svc.runner.sshd.CommandInfo;
import org.clazzes.svc.runner.sshd.CommandResolver;
import org.clazzes.svc.runner.sshd.ExceptionFnUtil;
import org.clazzes.svc.runner.sshd.PosixFileDescriptor;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.impl.AbstractPty;
import org.jline.terminal.impl.jansi.JansiNativePty;
import org.jline.terminal.impl.jna.JnaNativePty;
import org.jline.terminal.impl.jni.JniNativePty;
import org.jline.terminal.spi.Pty;
import org.jline.terminal.spi.SystemStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalCommandResolver
implements CommandResolver {
    private static final Logger log = LoggerFactory.getLogger(ExternalCommandResolver.class);
    private ExecutorService executor;

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    private static final FileDescriptor getRawStdin(Terminal terminal) {
        AbstractPty abstractPty;
        AbstractPosixTerminal posixTerm;
        if (!(terminal instanceof AbstractPosixTerminal) || (posixTerm = (AbstractPosixTerminal)terminal).getPty() == null) {
            log.warn("Unable to get raw stdin from terminal, because terminal is of unknown type {}.", (Object)terminal.getClass().getName());
            return null;
        }
        Pty pty = posixTerm.getPty();
        if (pty instanceof AbstractPty && (abstractPty = (AbstractPty)pty).getSystemStream() != null) {
            return switch (abstractPty.getSystemStream()) {
                default -> throw new IncompatibleClassChangeError();
                case SystemStream.Input -> FileDescriptor.in;
                case SystemStream.Output -> FileDescriptor.out;
                case SystemStream.Error -> FileDescriptor.err;
            };
        }
        if (pty instanceof JniNativePty) {
            JniNativePty jniPty = (JniNativePty)pty;
            return jniPty.getSlaveFD();
        }
        if (pty instanceof JnaNativePty) {
            JnaNativePty jnaPty = (JnaNativePty)pty;
            return jnaPty.getSlaveFD();
        }
        if (pty instanceof JansiNativePty) {
            JansiNativePty jansiPty = (JansiNativePty)pty;
            return jansiPty.getSlaveFD();
        }
        if (pty.getClass().getName().equals("org.jline.terminal.impl.ffm.FfmNativePty")) {
            FileDescriptor slaveFd;
            Method getSlaveFdMethod;
            try {
                getSlaveFdMethod = pty.getClass().getMethod("getSlaveFD", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                log.warn("Couldn't get getSlaveFD function from FfmNativePty", (Throwable)e);
                return null;
            }
            try {
                slaveFd = (FileDescriptor)getSlaveFdMethod.invoke((Object)pty, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                log.warn("Error while calling getSlaveFD function", (Throwable)e);
                return null;
            }
            return slaveFd;
        }
        log.warn("Unable to get raw stdin from terminal, because the pty has unknown type {}.", (Object)pty.getClass().getName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransfer(InputStream in, OutputStream out, Closeable closeable) {
        SelectionKey key = null;
        SelectableChannel channel = null;
        try {
            try (Closeable _c = closeable;
                 Selector selector = in instanceof FileInputStream ? Selector.open() : null;){
                if (in instanceof FileInputStream) {
                    FileInputStream file = (FileInputStream)in;
                    channel = Channels.readWriteSelectableChannel(file.getFD(), new Channels.SelectableChannelCloser(){

                        @Override
                        public void implCloseChannel(SelectableChannel arg0) throws IOException {
                        }

                        @Override
                        public void implReleaseChannel(SelectableChannel arg0) throws IOException {
                        }
                    });
                    channel.configureBlocking(false);
                    key = channel.register(selector, 1);
                }
                byte[] buffer = new byte[8192];
                while (true) {
                    int read;
                    if (key != null) {
                        selector.select();
                        if (Thread.interrupted()) {
                            break;
                        }
                        if (!key.isReadable()) continue;
                    }
                    if ((read = in.read(buffer)) < 0) {
                        break;
                    }
                    out.write(buffer, 0, read);
                    out.flush();
                }
            }
            finally {
                if (channel != null) {
                    channel.configureBlocking(true);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CliCommand command(String commandPath) {
        return params -> {
            ProcessBuilder processBuilder = new ProcessBuilder(Stream.concat(Stream.of(commandPath), params.arguments().stream().skip(1L)).toList()).redirectError(ProcessBuilder.Redirect.PIPE).redirectInput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).directory(new File(params.cwd()));
            processBuilder.environment().clear();
            processBuilder.environment().putAll(params.envVars());
            PosixFileDescriptor stdinFd = params.fds().get(0);
            Objects.requireNonNull(stdinFd, "No stdin connected.");
            Objects.requireNonNull(stdinFd.in(), "Stdin isn't readable");
            Process process = processBuilder.start();
            InputStream stdin = Optional.ofNullable(stdinFd.terminal()).map(term -> ExternalCommandResolver.getRawStdin(term)).map(fd -> new FileInputStream((FileDescriptor)fd)).orElse(stdinFd.in());
            CountDownLatch latch = new CountDownLatch(1);
            Future<?> future1 = this.executor.submit(() -> {
                try {
                    this.doTransfer(stdin, process.getOutputStream(), process.getOutputStream());
                }
                finally {
                    latch.countDown();
                }
            });
            Future<?> future2 = this.executor.submit(() -> this.doTransfer(process.getInputStream(), params.stdout(), process.getInputStream()));
            Future<?> future3 = this.executor.submit(() -> this.doTransfer(process.getErrorStream(), params.stderr(), process.getErrorStream()));
            int status = process.waitFor();
            future1.cancel(true);
            future2.get();
            future3.get();
            try {
                future1.get();
            }
            catch (CancellationException e) {
                log.debug("Cancelled", (Throwable)e);
            }
            latch.await();
            process.getInputStream().close();
            process.getErrorStream().close();
            process.getOutputStream().close();
            return status;
        };
    }

    private String[] getPath(CommandEnvironment env) {
        String env_path = System.getenv("PATH");
        return env_path.split(":");
    }

    @Override
    public CliCommand resolveCommand(String commandName, CommandEnvironment env) {
        if (commandName.startsWith("/")) {
            if (Files.isExecutable(Path.of(commandName, new String[0]))) {
                return this.command(commandName);
            }
            return null;
        }
        for (String path : this.getPath(env)) {
            Path combinedPath = Path.of(path, new String[0]).resolve(commandName);
            if (!Files.isExecutable(combinedPath)) continue;
            return this.command(combinedPath.toString());
        }
        return null;
    }

    private Stream<Path> listDirectoryIfExists(Path dir) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return Stream.empty();
        }
        return Files.list(dir);
    }

    @Override
    public List<CommandInfo> listCommands(String commandNamePrefix, CommandEnvironment env) {
        try {
            if (commandNamePrefix == null || commandNamePrefix.isEmpty()) {
                return List.of();
            }
            boolean isPath = commandNamePrefix.startsWith("/");
            if (isPath) {
                int lastSlashIndex = commandNamePrefix.lastIndexOf(47);
                String directory = commandNamePrefix.substring(0, lastSlashIndex);
                String searchPrefix = commandNamePrefix.substring(lastSlashIndex);
                return this.listDirectoryIfExists(Path.of(directory, new String[0])).filter(path -> path.getFileName().toString().startsWith(searchPrefix)).map(completion -> directory + String.valueOf(completion.getFileName())).map(name -> new CommandInfo((String)name, "External command")).toList();
            }
            return Arrays.stream(this.getPath(env)).flatMap(ExceptionFnUtil.sneakyFn(path -> this.listDirectoryIfExists(Path.of(path, new String[0])))).filter(path -> path.getFileName().toString().startsWith(commandNamePrefix)).map(path -> path.getFileName().toString()).distinct().map(commandName -> new CommandInfo((String)commandName, "External command")).toList();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

