/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.clazzes.parsercombinators.Parser;
import org.clazzes.parsercombinators.ParserUtils;
import org.clazzes.parsercombinators.string.StringParseInput;
import org.clazzes.parsercombinators.string.StringParser;

public class CommandParser {
    private static final Parser<CharSequence, Integer> pos = input_ -> {
        StringParseInput seq = StringParseInput.fromSequence((CharSequence)input_);
        return ParserUtils.ok((Object)seq, (Object)seq.getBeginIndex());
    };
    private static final Parser<CharSequence, ParsedCommand> parser = CommandParser.mkParser();
    private static final Pattern lineContinuationsPattern = Pattern.compile("\\\\(\n|\\\\)");

    private static final <T, R> List<R> mapList(List<T> list, Function<T, R> fn) {
        ArrayList<R> ret = new ArrayList<R>(list.size());
        for (T i : list) {
            ret.add(fn.apply(i));
        }
        return ret;
    }

    private static final Span mapSpan(Span span, IntUnaryOperator fn) {
        return new Span(fn.applyAsInt(span.start()), fn.applyAsInt(span.end()));
    }

    private static DoubleQuotedPart mapDoubleQuotedPartSpan(DoubleQuotedPart dqPart, IntUnaryOperator fn) {
        if (dqPart instanceof DoubleQuotedPart.QuotedLiteral) {
            DoubleQuotedPart.QuotedLiteral lit = (DoubleQuotedPart.QuotedLiteral)dqPart;
            return new DoubleQuotedPart.QuotedLiteral(lit.str(), CommandParser.mapSpan(lit.span(), fn));
        }
        if (dqPart instanceof DoubleQuotedPart.CommandSubstitution) {
            DoubleQuotedPart.CommandSubstitution sub = (DoubleQuotedPart.CommandSubstitution)dqPart;
            return new DoubleQuotedPart.CommandSubstitution(CommandParser.mapSpans(sub.command(), fn));
        }
        throw new RuntimeException("unsupported");
    }

    private static WordPart mapWordPartSpans(WordPart part, IntUnaryOperator fn) {
        if (part instanceof WordPart.CommandSubstitution) {
            WordPart.CommandSubstitution sub = (WordPart.CommandSubstitution)part;
            return new WordPart.CommandSubstitution(CommandParser.mapSpans(sub.command(), fn));
        }
        if (part instanceof WordPart.DoubleQuoted) {
            WordPart.DoubleQuoted doubleQuoted = (WordPart.DoubleQuoted)part;
            return new WordPart.DoubleQuoted(CommandParser.mapList(doubleQuoted.parts(), dqPart -> CommandParser.mapDoubleQuotedPartSpan(dqPart, fn)), CommandParser.mapSpan(doubleQuoted.openQuoteSpan(), fn), CommandParser.mapSpan(doubleQuoted.closeQuoteSpan(), fn));
        }
        if (part instanceof WordPart.Literal) {
            WordPart.Literal lit = (WordPart.Literal)part;
            return lit;
        }
        throw new RuntimeException("Unsupported");
    }

    private static final Word mapWordSpans(Word word, IntUnaryOperator fn) {
        return new Word(CommandParser.mapList(word.parts(), part -> CommandParser.mapWordPartSpans(part, fn)));
    }

    private static RedirectionKind mapRedirectionKindSpans(RedirectionKind kind, IntUnaryOperator fn) {
        if (kind instanceof RedirectionKind.Duplicate) {
            RedirectionKind.Duplicate dup = (RedirectionKind.Duplicate)kind;
            return new RedirectionKind.Duplicate(CommandParser.mapWordSpans(dup.duplicatedFd(), fn), dup.kind());
        }
        if (kind instanceof RedirectionKind.File) {
            RedirectionKind.File file = (RedirectionKind.File)kind;
            return new RedirectionKind.File(CommandParser.mapWordSpans(file.word(), fn), file.kind());
        }
        if (kind instanceof RedirectionKind.HereDocument) {
            RedirectionKind.HereDocument hereDoc = (RedirectionKind.HereDocument)kind;
            return hereDoc;
        }
        throw new RuntimeException("unsupported");
    }

    private static final Command mapCommandSpans(Command command, IntUnaryOperator fn) {
        if (command instanceof Command.Simple) {
            Command.Simple simple = (Command.Simple)command;
            return new Command.Simple(CommandParser.mapList(simple.redirections(), redirection -> new Redirection(CommandParser.mapRedirectionKindSpans(redirection.kind(), fn), redirection.fd())), CommandParser.mapList(simple.assignments(), assignment -> new AssignmentWord(assignment.key(), CommandParser.mapWordSpans(assignment.value(), fn))), CommandParser.mapWordSpans(simple.mainWord(), fn), CommandParser.mapSpan(simple.mainWordSpan(), fn), CommandParser.mapList(simple.otherWords(), otherWord -> CommandParser.mapWordSpans(otherWord, fn)));
        }
        throw new RuntimeException("Unsupported kind of command");
    }

    private static final Pipeline mapPipelineSpans(Pipeline input, IntUnaryOperator fn) {
        return new Pipeline(input.hasBang(), CommandParser.mapList(input.commands(), command -> CommandParser.mapCommandSpans(command, fn)));
    }

    private static final ParsedCommand mapSpans(ParsedCommand input, IntUnaryOperator fn) {
        return new ParsedCommand(CommandParser.mapList(input.list(), listElement -> new PosixListElement(listElement.mode(), new AndOr(CommandParser.mapPipelineSpans(listElement.andOr().firstPipeline(), fn), CommandParser.mapList(listElement.andOr().elements(), andOrElement -> new AndOrElement(andOrElement.mode(), CommandParser.mapPipelineSpans(andOrElement.pipeline(), fn)))))));
    }

    private static final <T, R> Parser<CharSequence, R> withSpan(BiFunction<T, Span, R> fn, Parser<CharSequence, T> p) {
        return ParserUtils.and((start, value, end) -> fn.apply(value, new Span((int)start, (int)end)), pos, p, pos);
    }

    private static final Parser<CharSequence, ParsedCommand> mkParser() {
        Parser commandParserRet = ParserUtils.fixParser(commandParser -> {
            Parser optionalWhitespace = StringParser.regex((String)"[ \t]*").map(m -> null).named("optionalWhitespace");
            Parser mandatoryWhitespace = StringParser.regex((String)"[ \t]+").map(m -> null).named("mandatoryWhitespace");
            Parser optionalLinebreak = StringParser.regex((String)"[ \t\r\n]*").map(m -> null).named("optionalLinebreak");
            Parser mandatoryLinebreak = StringParser.regex((String)"[ \t\r]*\n[ \t\r\n]*").map(m -> null).named("mandatoryLinebreak");
            Parser and_if = StringParser.matchesString((String)"&&");
            Parser or_if = StringParser.matchesString((String)"||");
            Parser singleQuotedString = StringParser.regex((String)"'([^']*)'").map(match -> match.group(1)).named("singleQuotedString");
            Parser backslashEscape = StringParser.regex((String)"\\\\(.)").map(m -> m.group(1)).named("backslashEscape");
            Pattern backTickedUnEscapePattern = Pattern.compile("\\\\(.)", 32);
            Function<Boolean, Parser> backTicked = quoted -> ParserUtils.and((a, commandStartPos, command, b) -> {
                Map.Entry<String, IntUnaryOperator> unEscaped = CommandParser.replaceAllWithPositions(command, backTickedUnEscapePattern, m -> {
                    if ("$`\\".contains(m.group(1))) {
                        return m.group(1);
                    }
                    if ("\"".equals(m.group(1)) && quoted.booleanValue()) {
                        return "\"";
                    }
                    return m.group();
                });
                System.out.println("unEscaped = " + String.valueOf(unEscaped));
                return CommandParser.mapSpans(CommandParser.parseCommand(unEscaped.getKey()), posToMap -> commandStartPos + ((IntUnaryOperator)unEscaped.getValue()).applyAsInt(posToMap));
            }, (Parser)StringParser.single((char)'`'), pos, (Parser)StringParser.regex((String)"(?:(?:\\\\.)|[^`])*", (int)32).map(m -> m.group()), (Parser)StringParser.single((char)'`')).named("backTicked");
            Parser commandSubstitution = ParserUtils.delimited((Parser)StringParser.single((char)'('), (Parser)commandParser, (Parser)StringParser.single((char)')')).named("commandSubstitution");
            Parser doubleQuotedLiteral = ParserUtils.some((Parser)ParserUtils.or((Parser)backslashEscape, (Parser)StringParser.regex((String)"[^\\\\$`\"]+").map(m -> m.group()))).map(list -> list.stream().collect(Collectors.joining(""))).named("doubleQuotedLiteral");
            Parser normalLiteral = ParserUtils.some((Parser)ParserUtils.or((Parser)backslashEscape, (Parser)StringParser.regex((String)("[^" + Pattern.quote("[{}|&;<>()\\ '\t\n\r\u00a0\\\"$`?*@!+\u201c\u201d\u2033\u2036\u2018\u2019") + "]+")).map(m -> m.group()))).map(list -> list.stream().collect(Collectors.joining(""))).named("normalLiteral");
            Parser doubleQuotedPart = ParserUtils.or((Parser[])new Parser[]{CommandParser.withSpan(DoubleQuotedPart.QuotedLiteral::new, doubleQuotedLiteral), backTicked.apply(true).map(DoubleQuotedPart.CommandSubstitution::new), ParserUtils.discardingFirst((Parser)StringParser.single((char)'$'), (Parser)ParserUtils.or((Parser)commandSubstitution.map(DoubleQuotedPart.CommandSubstitution::new), (Parser)pos.map(posValue -> new DoubleQuotedPart.QuotedLiteral("$", new Span(posValue - 1, (int)posValue)))))}).named("doubleQuotedPart");
            Parser doubleQuotedString = ParserUtils.and((openSpan, parts, closeSpan) -> new WordPart.DoubleQuoted((List<DoubleQuotedPart>)parts, (Span)openSpan, (Span)closeSpan), CommandParser.withSpan((a, b) -> b, StringParser.single((char)'\"')), (Parser)ParserUtils.many((Parser)doubleQuotedPart), CommandParser.withSpan((a, b) -> b, StringParser.single((char)'\"'))).named("doubleQuotedString");
            Parser wordPart = ParserUtils.or((Parser[])new Parser[]{singleQuotedString.map(WordPart.Literal::new), doubleQuotedString, backTicked.apply(false).map(WordPart.CommandSubstitution::new), ParserUtils.discardingFirst((Parser)StringParser.single((char)'$'), (Parser)ParserUtils.or((Parser)commandSubstitution.map(WordPart.CommandSubstitution::new), (Parser)ParserUtils.pure((Object)new WordPart.Literal("$")))), normalLiteral.map(WordPart.Literal::new)}).named("wordPart");
            Parser word = ParserUtils.some((Parser)wordPart).map(Word::new).named("word");
            Parser cmdWord = word.map(CmdWord::new);
            Parser ioRedirect = ParserUtils.and((fd, kind) -> new Redirection((RedirectionKind)kind, fd.orElseGet(() -> {
                RedirectionKind.File file;
                RedirectionKind.Duplicate dup;
                int n = kind instanceof RedirectionKind.Duplicate ? ((dup = (RedirectionKind.Duplicate)kind).kind() == DuplicateKind.OUTPUT ? 1 : 0) : (kind instanceof RedirectionKind.File ? ((file = (RedirectionKind.File)kind).kind() == FileRedirectionKind.INPUT ? 0 : 1) : 0);
                return n;
            })), (Parser)ParserUtils.optional((Parser)StringParser.regex((String)"[0-9]{1,9}").map(m -> m.group()).map(Integer::valueOf).named("fd")), (Parser)ParserUtils.or((Parser)ParserUtils.and((kind, wordValue) -> new RedirectionKind.Duplicate((Word)wordValue, (DuplicateKind)((Object)((Object)kind))), (Parser)ParserUtils.or((Parser[])new Parser[]{StringParser.matchesString((String)"<>").map(v -> DuplicateKind.BOTH), StringParser.matchesString((String)">&").map(v -> DuplicateKind.OUTPUT), StringParser.matchesString((String)"<&").map(v -> DuplicateKind.INPUT)}), (Parser)ParserUtils.discardingFirst((Parser)optionalWhitespace, (Parser)word)), (Parser)ParserUtils.and((kind, wordValue) -> new RedirectionKind.File((Word)wordValue, (FileRedirectionKind)((Object)((Object)kind))), (Parser)ParserUtils.or((Parser[])new Parser[]{StringParser.matchesString((String)">|").map(v -> FileRedirectionKind.OUTPUT_FORCE_CLOBBER), StringParser.matchesString((String)">>").map(v -> FileRedirectionKind.APPEND), StringParser.matchesString((String)">").map(v -> FileRedirectionKind.OUTPUT), StringParser.matchesString((String)"<").map(v -> FileRedirectionKind.INPUT)}), (Parser)ParserUtils.discardingFirst((Parser)optionalWhitespace, (Parser)word)))).named("redirection");
            Parser variableName = StringParser.regex((String)"[\\p{Lu}\\p{Ll}_][0-9\\p{Lu}\\p{Ll}_]*").map(m -> m.group()).named("variableName");
            Parser assignmentWord = ParserUtils.and(AssignmentWord::new, (Parser)variableName, (Parser)ParserUtils.discardingFirst((Parser)StringParser.single((char)'='), (Parser)word)).named("assignmentWord");
            Parser cmdPrefix = ParserUtils.many((Parser)ParserUtils.discardingSecond((Parser)ParserUtils.or((Parser)ioRedirect.map(v -> v), (Parser)assignmentWord.map(v -> v)), (Parser)mandatoryWhitespace)).named("cmdPrefix");
            Parser cmdSuffix = ParserUtils.many((Parser)ParserUtils.discardingFirst((Parser)mandatoryWhitespace, (Parser)ParserUtils.or((Parser)ioRedirect.map(v -> v), (Parser)cmdWord.map(v -> v)))).named("cmdSuffix");
            Parser simpleCommand = ParserUtils.and((prefixValue, startWord, wordValue, endWord, suffixValue) -> new Command.Simple(Stream.concat(prefixValue.stream().flatMap(element -> {
                Stream<Object> stream;
                if (element instanceof Redirection) {
                    Redirection ret = (Redirection)element;
                    stream = Stream.of(ret);
                } else {
                    stream = Stream.empty();
                }
                return stream;
            }), suffixValue.stream().flatMap(element -> {
                Stream<Object> stream;
                if (element instanceof Redirection) {
                    Redirection ret = (Redirection)element;
                    stream = Stream.of(ret);
                } else {
                    stream = Stream.empty();
                }
                return stream;
            })).toList(), prefixValue.stream().flatMap(element -> {
                Stream<Object> stream;
                if (element instanceof AssignmentWord) {
                    AssignmentWord ret = (AssignmentWord)element;
                    stream = Stream.of(ret);
                } else {
                    stream = Stream.empty();
                }
                return stream;
            }).toList(), wordValue.word(), new Span((int)startWord, (int)endWord), suffixValue.stream().flatMap(element -> {
                Stream<Object> stream;
                if (element instanceof CmdWord) {
                    CmdWord ret = (CmdWord)element;
                    stream = Stream.of(ret.word());
                } else {
                    stream = Stream.empty();
                }
                return stream;
            }).toList()), (Parser)cmdPrefix, pos, (Parser)cmdWord, pos, (Parser)cmdSuffix).named("simpleCommand");
            Parser command = ParserUtils.or((Parser[])new Parser[]{simpleCommand.map(v -> v)}).named("command");
            Parser pipeline = ParserUtils.and(Pipeline::new, (Parser)ParserUtils.optional((Parser)ParserUtils.discardingSecond((Parser)StringParser.single((char)'!'), (Parser)mandatoryWhitespace)).map(o -> o.isPresent()), (Parser)ParserUtils.someWithSeparator((Parser)command, (Parser)ParserUtils.delimited((Parser)optionalWhitespace, (Parser)StringParser.single((char)'|'), (Parser)optionalLinebreak))).named("pipeline");
            Parser andOrElement = ParserUtils.and(AndOrElement::new, (Parser)ParserUtils.delimited((Parser)optionalWhitespace, (Parser)ParserUtils.or((Parser)and_if.map(s -> AndOrMode.AND), (Parser)or_if.map(s -> AndOrMode.OR)), (Parser)optionalLinebreak), (Parser)pipeline).named("andOrElement");
            Parser andOr = ParserUtils.and(AndOr::new, (Parser)pipeline, (Parser)ParserUtils.many((Parser)andOrElement)).named("andOr");
            Parser separatorOp = ParserUtils.or((Parser)ParserUtils.delimited((Parser)optionalWhitespace, (Parser)ParserUtils.or((Parser)StringParser.single((char)'&').map(c -> SyncMode.ASYNC), (Parser)StringParser.single((char)';').map(c -> SyncMode.SYNC)), (Parser)optionalWhitespace), (Parser)mandatoryLinebreak.map(c -> SyncMode.SYNC)).named("separatorOp");
            Parser list2 = ParserUtils.fixParser(restParser -> ParserUtils.optional((Parser)ParserUtils.and((element, restValue) -> Stream.concat(Stream.of(new PosixListElement(restValue.map(Map.Entry::getKey).orElse(SyncMode.SYNC), (AndOr)element)), restValue.stream().flatMap(Map.Entry::getValue)), (Parser)andOr, (Parser)ParserUtils.optional((Parser)ParserUtils.and(Map::entry, (Parser)separatorOp, (Parser)restParser)))).map(opt -> opt.orElseGet(Stream::empty))).map(Stream::toList);
            return ParserUtils.delimited((Parser)optionalLinebreak, (Parser)list2, (Parser)optionalLinebreak).map(ParsedCommand::new).named("commandParser");
        });
        return StringParser.withEof((Parser)commandParserRet);
    }

    private static final Map.Entry<String, IntUnaryOperator> replaceAllWithPositions(String input, Pattern pattern, Function<MatchResult, String> replacer) {
        TreeMap substitutionsMap = new TreeMap();
        String resultString = pattern.matcher(input).replaceAll(m -> {
            String replacement = (String)replacer.apply((MatchResult)m);
            int matchLength = m.end() - m.start();
            if (replacement.length() != matchLength) {
                Integer previousPosShift = Optional.ofNullable(substitutionsMap.lastEntry()).map(Map.Entry::getValue).orElse(0);
                int newPosShift = previousPosShift + (matchLength - replacement.length());
                substitutionsMap.put(m.start() - previousPosShift, newPosShift);
            }
            return Matcher.quoteReplacement(replacement);
        });
        return Map.entry(resultString, pos -> pos + Optional.ofNullable(substitutionsMap.floorEntry(pos)).map(Map.Entry::getValue).orElse(0));
    }

    public static final ParsedCommand parseCommand(String commandString) {
        Map.Entry<String, IntUnaryOperator> strippedLineContinuations = CommandParser.replaceAllWithPositions(commandString, lineContinuationsPattern, m -> {
            if (m.group(1).charAt(0) == '\n') {
                return "";
            }
            return m.group();
        });
        return CommandParser.mapSpans((ParsedCommand)StringParser.parseFinal(parser, (CharSequence)strippedLineContinuations.getKey()), strippedLineContinuations.getValue());
    }

    public record Span(int start, int end) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface DoubleQuotedPart {

        public record CommandSubstitution(ParsedCommand command) implements DoubleQuotedPart
        {
        }

        public record QuotedLiteral(String str, Span span) implements DoubleQuotedPart
        {
        }
    }

    public record ParsedCommand(List<PosixListElement> list) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface WordPart {

        public record CommandSubstitution(ParsedCommand command) implements WordPart
        {
        }

        public record DoubleQuoted(List<DoubleQuotedPart> parts, Span openQuoteSpan, Span closeQuoteSpan) implements WordPart
        {
        }

        public record Literal(String str) implements WordPart
        {
        }
    }

    public record Word(List<WordPart> parts) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface RedirectionKind {

        public record HereDocument(String document) implements RedirectionKind
        {
        }

        public record Duplicate(Word duplicatedFd, DuplicateKind kind) implements RedirectionKind
        {
        }

        public record File(Word word, FileRedirectionKind kind) implements RedirectionKind
        {
        }
    }

    public static enum DuplicateKind {
        INPUT,
        OUTPUT,
        BOTH;

    }

    public static enum FileRedirectionKind {
        INPUT,
        OUTPUT,
        OUTPUT_FORCE_CLOBBER,
        APPEND;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Command {

        public record FunctionDefinition() implements Command
        {
        }

        public record Compound() implements Command
        {
        }

        public record Simple(List<Redirection> redirections, List<AssignmentWord> assignments, Word mainWord, Span mainWordSpan, List<Word> otherWords) implements Command
        {
        }
    }

    public record Pipeline(boolean hasBang, List<Command> commands) {
    }

    public record PosixListElement(SyncMode mode, AndOr andOr) {
    }

    public static enum SyncMode {
        ASYNC,
        SYNC;

    }

    public record AndOr(Pipeline firstPipeline, List<AndOrElement> elements) {
    }

    public static enum AndOrMode {
        AND,
        OR;

    }

    private record CmdWord(Word word) implements SuffixElement
    {
    }

    public record AssignmentWord(String key, Word value) implements PrefixElement
    {
    }

    public record Redirection(RedirectionKind kind, int fd) implements PrefixElement,
    SuffixElement
    {
    }

    public record AndOrElement(AndOrMode mode, Pipeline pipeline) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface SuffixElement {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface PrefixElement {
    }
}

