/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.clazzes.svc.runner.sshd.CloseProtectedOutputStream;
import org.clazzes.svc.runner.sshd.PosixFileDescriptor;

public record CommandEnvironment(Map<String, String> envVars, Map<Integer, PosixFileDescriptor> fds, String cwd) implements Closeable
{
    public CommandEnvironment(CommandEnvironment other) {
        this(other.envVars(), other.fds(), other.cwd());
    }

    public InputStream stdin() {
        return Objects.requireNonNull(Objects.requireNonNull(this.fds.get(0), "No stdin stream defined").in());
    }

    public OutputStream stdout() {
        return Objects.requireNonNull(Objects.requireNonNull(this.fds.get(1), "No stdout stream defined").out());
    }

    public OutputStream stderr() {
        return Objects.requireNonNull(Objects.requireNonNull(this.fds.get(2), "No stderr stream defined").out());
    }

    public CommandEnvironment withFds(Map<Integer, PosixFileDescriptor> fds) {
        return new CommandEnvironment(this.envVars, fds, this.cwd);
    }

    public CommandEnvironment withFd(int key, PosixFileDescriptor value) {
        if (this.fds().get(key) != null) {
            this.fds().get(key).close();
        }
        HashMap<Integer, PosixFileDescriptor> newFds = new HashMap<Integer, PosixFileDescriptor>(this.fds());
        newFds.put(key, value);
        return this.withFds(newFds);
    }

    public CommandEnvironment withStdout(PosixFileDescriptor value) {
        return this.withFd(1, value);
    }

    public CommandEnvironment withStdin(PosixFileDescriptor value) {
        return this.withFd(0, value);
    }

    public CommandEnvironment duplicate() {
        return new CommandEnvironment(this.envVars, this.fds.entrySet().stream().map(entry -> Map.entry((Integer)entry.getKey(), ((PosixFileDescriptor)entry.getValue()).duplicate())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), this.cwd);
    }

    @Override
    public void close() {
        for (PosixFileDescriptor posixFd : this.fds.values()) {
            posixFd.close();
        }
    }

    public PrintWriter fdWriter(int fd) {
        return new PrintWriter(new CloseProtectedOutputStream(this.fds.get(fd).out()), false, StandardCharsets.UTF_8);
    }

    public PrintWriter stderrWriter() {
        return this.fdWriter(2);
    }

    public PrintWriter stdoutWriter() {
        return this.fdWriter(1);
    }

    public void printException(Throwable e) {
        try (PrintWriter writer = this.stdoutWriter();){
            e.printStackTrace(writer);
        }
    }
}

