package org.clazzes.svc.runner.sshd;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.jline.terminal.Terminal;

// All fields are nullable.
public record PosixFileDescriptor(RefCountedInputStream in, RefCountedOutputStream out, Terminal terminal) implements Closeable {
    @SuppressWarnings("unused")
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(PosixFileDescriptor.class);

    public static PosixFileDescriptor ofInput(InputStream in) {
        return new PosixFileDescriptor(new RefCountedInputStream(in), null, null);
    }

    public static PosixFileDescriptor ofOutput(OutputStream out) {
        return new PosixFileDescriptor(null, new RefCountedOutputStream(out), null);
    }

    public static PosixFileDescriptor ofTerminal(Terminal terminal) {
        return new PosixFileDescriptor(
            new RefCountedInputStream(terminal.input()),
            new RefCountedOutputStream(terminal.output()),
            terminal
        );
    }

    public PosixFileDescriptor duplicate() {
        return new PosixFileDescriptor(
            in == null
                ? null
                : new RefCountedInputStream(in),
            out == null
                ? null
                : new RefCountedOutputStream(out),
            terminal
        );
    }

    public PosixFileDescriptor onlyInput() {
        return new PosixFileDescriptor(in, null, terminal);
    }

    public PosixFileDescriptor onlyOutput() {
        return new PosixFileDescriptor(null, out, terminal);
    }

    @Override
    public void close() {
        if (in != null) {
            log.debug("Closing in {}", in);
            try {
                in.close();
            } catch (IOException e) {
                log.warn("Unable to close {}", in, e);
            }
        }
        if (out != null) {
            log.debug("Closing out {}", out);
            try {
                out.close();
            } catch (IOException e) {
                log.warn("Unable to close {}", out, e);
            }
        }
    }
}
