package org.clazzes.svc.runner.sshd;

import java.util.List;

public class ListResolver implements CommandResolver {
    private final List<CommandResolver> children;

    public ListResolver(List<CommandResolver> children) {
        this.children = children;
    }

    @Override
    public CliCommand resolveCommand(String commandName, CommandEnvironment env) {
        for (var child: children) {
            try {
                var ret = child.resolveCommand(commandName, env);
                if (ret != null) {
                    return ret;
                }
            } catch (Exception e) {
                env.printException(e);
            }
        }
        return null;
    }

    @Override
    public List<CommandInfo> listCommands(String commandNamePrefix, CommandEnvironment env) {
        return children
            .stream()
            .flatMap(child -> child.listCommands(commandNamePrefix, env).stream())
            .toList();
    }


}
