package org.clazzes.svc.runner.sshd;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executors;

import org.clazzes.parsercombinators.ParseException;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public class IndieShell {
    public static final void main(String[] args) {
        var executor = Executors.newCachedThreadPool();

        var externalResolver = new ExternalCommandResolver();
        externalResolver.setExecutor(executor);

        try (
            var terminal = TerminalBuilder.builder()
                .system(true)
                .build();
        ) {
            InteractiveShell.runInteractiveShell(
                IndieShell.class.getModule().getDescriptor().version().get().toString(),
                executor,
                externalResolver,
                terminal,
                System.getenv(),
                System.getProperty("user.dir")
            );
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            System.out.println("Shutting down executor.");
            executor.shutdown();
            System.out.println("Shut down executor.");
        }
    }
}
