package org.clazzes.svc.runner.sshd;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public record CommandParameters(
    CommandEnvironment env,
    // The first element is the command name.
    List<String> arguments
) {
    public Map<String, String> envVars() {
        return this.env.envVars();
    }

    public Map<Integer, PosixFileDescriptor> fds() {
        return this.env.fds();
    }

    public String cwd() {
        return this.env.cwd();
    }

    public InputStream stdin() {
        return this.env.stdin();
    }

    public OutputStream stdout() {
        return this.env.stdout();
    }

    public OutputStream stderr() {
        return this.env.stderr();
    }
}
