package org.clazzes.svc.runner.sshd;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.jline.reader.Candidate;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.CompletionMatcher;
import org.jline.reader.LineReader;

public class CommandCompletionMatcher implements CompletionMatcher {
    // Implementation stolen from https://github.com/AceBlox/CloudNet-v3/blob/554d56d5a3a34df3abd827d4ab8a9d8e14afc8e9/node/src/main/java/eu/cloudnetservice/node/console/JLine3CompletionMatcher.java
    private volatile List<Candidate> candidates;
    private volatile CompletingParsedLine parsedLine;

    @Override
    public void compile(
        Map<LineReader.Option, Boolean> options,
        boolean prefix,
        CompletingParsedLine line,
        boolean caseInsensitive,
        int errors,
        String originalGroupName
    ) {
        this.candidates = null;
        this.parsedLine = line;
    }

    @Override
    public  List<Candidate> matches( List<Candidate> candidates) {
        this.candidates = candidates;
        return candidates;
    }

    @Override
    public Candidate exactMatch() {
        // keep a local copy of the variables in case of concurrent calls
        var candidates = Objects.requireNonNull(this.candidates);
        var parsedLine = Objects.requireNonNull(this.parsedLine);

        // check if there is a 100% match
        var givenWord = parsedLine.word();
        for (var candidate : candidates) {
            if (candidate.complete() && givenWord.equalsIgnoreCase(candidate.value())) {
                return candidate;
            }
        }

        // no exact match
        return null;
    }

    // Stolen from https://github.com/google/guava/blob/b8dcaede09bcf1c3bd5fc037690498f6ac560c54/guava/src/com/google/common/base/Strings.java#L226C1-L231C4
    static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0
               && index <= (string.length() - 2)
               && Character.isHighSurrogate(string.charAt(index))
               && Character.isLowSurrogate(string.charAt(index + 1));
    }

    // Stolen from https://github.com/google/guava/blob/b8dcaede09bcf1c3bd5fc037690498f6ac560c54/guava/src/com/google/common/base/Strings.java#L183
    private static final String commonPrefix(CharSequence a, CharSequence b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);

        int maxPrefixLength = Math.min(a.length(), b.length());
        int p = 0;
        while (p < maxPrefixLength && a.charAt(p) == b.charAt(p)) {
            p++;
        }
        if (validSurrogatePairAt(a, p - 1) || validSurrogatePairAt(b, p - 1)) {
            p--;
        }
        return a.subSequence(0, p).toString();
    }


    @Override
    public String getCommonPrefix() {
        // keep a local copy of the candidates in case of concurrent calls
        var candidates = Objects.requireNonNull(this.candidates);

        String commonPrefix = null;
        for (var candidate : candidates) {
            if (candidate.complete()) {
                if (commonPrefix == null) {
                    // no common prefix yet
                    commonPrefix = candidate.value();
                } else {
                    // get the common prefix
                    commonPrefix = commonPrefix(commonPrefix, candidate.value());
                }
            }
        }
        return commonPrefix;
    }
}
