package org.clazzes.svc.runner.sshd;

import java.io.IOException;
import java.io.OutputStream;

// This wraps an OutputStream such that the close method doesn't actually do anything.
public class CloseProtectedOutputStream extends OutputStream {
    private boolean closed = false;
    private final OutputStream underlying;
    public CloseProtectedOutputStream(OutputStream underlying) {
        this.underlying = underlying;
    }

    @Override
    public void flush() throws IOException {
        if (closed) {
            throw new IOException("Stream closed");
        }

        this.underlying.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (closed) {
            throw new IOException("Stream closed");
        }

        this.underlying.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[] { (byte) b });
    }


    @Override
    public void close() throws IOException {
        if (closed) {
            return;
        }
        this.flush();
        closed = true;
    }

    @Override
    public String toString() {
        return "CloseProtectedOutputStream [underlying=" + underlying + "]";
    }
}
