package org.clazzes.svc.runner.sshd;

import java.io.IOException;
import java.io.InputStream;

// This wraps an InputStream such that the close method doesn't actually do anything.
public class CloseProtectedInputStream extends InputStream {
    private boolean closed = false;
    private final InputStream underlying;
    public CloseProtectedInputStream(InputStream underlying) {
        this.underlying = underlying;
    }


    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (closed) {
            throw new IOException("Stream closed");
        }

        return this.underlying.read(b, off, len);
    }

    @Override
    public int read() throws IOException {
        var buffer = new byte[1];
        var read = this.read(buffer, 0, 1);
        return read <= 0 ? -1 : buffer[0];
    }


    @Override
    public void close() throws IOException {
        closed = true;
    }


    @Override
    public String toString() {
        return "CloseProtectedInputStream [underlying=" + underlying + "]";
    }
}
