/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd.cmd;

import java.io.PrintStream;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.clazzes.svc.api.ComponentInfo;
import org.clazzes.svc.api.ComponentLayerInfo;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ConfigPidInfo;
import org.clazzes.svc.api.ConfigWrapper;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.HasThrowableInfos;
import org.clazzes.svc.api.ModuleInfo;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceInfo;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.svc.api.ThrowableInfo;
import org.clazzes.svc.api.cmd.Argument;
import org.clazzes.svc.api.cmd.CommandSet;
import org.clazzes.svc.api.cmd.Descriptor;
import org.clazzes.svc.api.cmd.Parameter;

@Descriptor(value="Core svc-runner commands.")
public class SvcCommands
implements CommandSet {
    private static final DateTimeFormatter THROWABLE_DTF = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSS");
    private static final List<String> COMMANDS = List.of("config", "layers", "ls", "pids", "modules", "services", "start", "stop", "reload");
    private final ServiceRegistry serviceRegistry;
    private final ComponentManager componentManager;
    private final ConfigurationEngine configurationEngine;

    protected static <T> int calcWidth(List<T> lst, int minWidth, Function<T, String> accessor) {
        int width = minWidth;
        for (T t : lst) {
            String x = accessor.apply(t);
            if (x == null || x.length() <= width) continue;
            width = x.length();
        }
        return width;
    }

    protected static void printThrowables(PrintStream out, HasThrowableInfos throwables, boolean stacktraces) {
        List lst = throwables.getThrowables();
        if (lst == null) {
            return;
        }
        for (ThrowableInfo ti : lst) {
            out.append(THROWABLE_DTF.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(ti.getTimestamp()), ZoneId.systemDefault())));
            out.append(" ERROR ");
            out.append(ti.getMessage());
            if (ti.getThrowable() == null) continue;
            if (stacktraces) {
                out.println();
                ti.getThrowable().printStackTrace(out);
                continue;
            }
            out.append(": ");
            out.append(ti.getThrowable().getMessage());
            out.println();
        }
    }

    public SvcCommands(ServiceContext svcCtxt) {
        this.serviceRegistry = (ServiceRegistry)svcCtxt.getService(ServiceRegistry.class).get();
        this.componentManager = (ComponentManager)svcCtxt.getService(ComponentManager.class).get();
        this.configurationEngine = (ConfigurationEngine)svcCtxt.getService(ConfigurationEngine.class).get();
    }

    public List<String> getCommands() {
        return COMMANDS;
    }

    @Descriptor(value="Show module layers.")
    public void layers(PrintStream out) {
        List layers = this.componentManager.listLayers();
        String fmt = "| %-10s| %-10s| %s";
        out.println(String.format(Locale.ENGLISH, fmt, "ID", "Parent", "Path"));
        for (ComponentLayerInfo layer : layers) {
            out.println(String.format(Locale.ENGLISH, fmt, layer.getLabel(), SvcCommands.norv(layer.getParent()), layer.getPath()));
        }
    }

    private static final String nameAndVersion(ModuleInfo mi) {
        if (mi.getVersion().isPresent()) {
            return mi.getName() + "@" + String.valueOf(mi.getVersion().get());
        }
        return mi.getName();
    }

    @Descriptor(value="List modules.")
    public void modules(PrintStream out, @Descriptor(value="Show module locations, too.") @Parameter(names={"-l", "--locations"}, presentValue="true", absentValue="false") boolean locations, @Descriptor(value="An optional list of layers to list modules of.") @Argument(value="layer") String[] layers) {
        ArrayList modules;
        if (layers == null || layers.length == 0) {
            modules = this.componentManager.listModules();
        } else {
            modules = new ArrayList(256);
            for (String layer : layers) {
                modules.addAll(this.componentManager.listModules(layer));
            }
        }
        if (locations) {
            int w1 = SvcCommands.calcWidth(modules, 12, mi -> SvcCommands.nameAndVersion(mi));
            String fmt = "| %-10s| %-" + w1 + "s| %s";
            out.println(String.format(Locale.ENGLISH, fmt, "Layer", "Name@Version", "Location"));
            for (ModuleInfo mi2 : modules) {
                Optional loc = mi2.getLocation();
                String loc_s = loc.isPresent() ? ((URI)loc.get()).toString() : "-";
                out.println(String.format(Locale.ENGLISH, fmt, mi2.getLayer(), SvcCommands.nameAndVersion(mi2), loc_s));
            }
        } else {
            String fmt = "| %-10s| %s";
            out.println(String.format(Locale.ENGLISH, fmt, "Layer", "Name@Version"));
            for (ModuleInfo mi3 : modules) {
                out.println(String.format(Locale.ENGLISH, fmt, mi3.getLayer(), SvcCommands.nameAndVersion(mi3)));
            }
        }
    }

    @Descriptor(value="List components.")
    public void ls(PrintStream out, @Descriptor(value="Show modules, too.") @Parameter(names={"-l", "--modules"}, presentValue="true", absentValue="false") boolean modules, @Descriptor(value="Show stacktraces, too.") @Parameter(names={"-s", "--stacktraces"}, presentValue="true", absentValue="false") boolean stacktraces, @Descriptor(value="An optional list of filters [layer/]module[@version] to list modules of.") @Argument(value="filter") String[] filters) {
        String fmt;
        ArrayList components;
        if (filters == null || filters.length == 0) {
            components = this.componentManager.listComponents();
        } else {
            components = new ArrayList(256);
            for (String filter : filters) {
                components.addAll(this.componentManager.listComponents(filter));
            }
        }
        int w1 = SvcCommands.calcWidth(components, 4, ComponentInfo::getName);
        String string = fmt = modules ? "| %-" + w1 + "s| %-10s| %3s | %s" : "| %-" + w1 + "s| %-10s| %s";
        if (modules) {
            out.println(String.format(Locale.ENGLISH, fmt, "Name", "State", "Pri", "Module"));
        } else {
            out.println(String.format(Locale.ENGLISH, fmt, "Name", "State", "Pri"));
        }
        fmt = modules ? "| %-" + w1 + "s| %-10s| %3d | %s" : "| %-" + w1 + "s| %-10s| %3d";
        for (ComponentInfo mi : components) {
            if (modules) {
                ModuleInfo mod = mi.getModule();
                out.println(String.format(Locale.ENGLISH, fmt, mi.getName(), mi.getState(), mi.getPriority(), SvcCommands.nameAndVersion(mod)));
            } else {
                out.println(String.format(Locale.ENGLISH, fmt, mi.getName(), mi.getState(), mi.getPriority()));
            }
            SvcCommands.printThrowables(out, (HasThrowableInfos)mi, stacktraces);
        }
    }

    @Descriptor(value="Start given components")
    public void start(PrintStream out, @Descriptor(value="Component list [layer/]module[@version] services to start") @Argument(value="component") String[] components) {
        for (String component : components) {
            out.println("Starting component [" + component + "]");
            this.componentManager.startComponent(component);
        }
    }

    @Descriptor(value="Stop given components")
    public void stop(PrintStream out, @Descriptor(value="Component list [layer/]module[@version] services to stop") @Argument(value="component") String[] components) {
        for (String component : components) {
            out.println("Stopping component [" + component + "]");
            this.componentManager.stopComponent(component);
        }
    }

    @Descriptor(value="Reload the given layer.")
    public void reload(PrintStream out, @Descriptor(value="Timeout in seconds to wait for the stop of components.") @Parameter(names={"-t", "--timeout"}, absentValue="10") int timeout, @Descriptor(value="Name of layer to reload.") @Argument(value="layer") String layer) {
        out.println("Reloading layer [" + layer + "]");
        this.componentManager.reloadLayer(layer, (long)timeout * 1000L);
    }

    @Descriptor(value="List registered services")
    public void services(PrintStream out, @Descriptor(value="Show stacktraces, too.") @Parameter(names={"-s", "--stacktraces"}, presentValue="true", absentValue="false") boolean stacktraces, @Descriptor(value="Optional list of interfaces to list") @Argument(value="interface") String[] ifaces) {
        ArrayList services;
        if (ifaces == null || ifaces.length == 0) {
            services = this.serviceRegistry.listServices();
        } else {
            services = new ArrayList(512);
            for (String iface : ifaces) {
                services.addAll(this.serviceRegistry.listServices(iface));
            }
        }
        int w1 = SvcCommands.calcWidth(services, 8, ServiceInfo::getIface);
        int w2 = SvcCommands.calcWidth(services, 3, ServiceInfo::getKey);
        String fmt = "| %-" + w1 + "s| %-" + w2 + "s| %s";
        out.println(String.format(Locale.ENGLISH, fmt, "Interface", "Key", "Implementation"));
        for (ServiceInfo si : services) {
            out.println(String.format(Locale.ENGLISH, fmt, si.getIface(), si.getKey(), si.getImplementation()));
            SvcCommands.printThrowables(out, (HasThrowableInfos)si, stacktraces);
        }
    }

    private static final String norv(Object x) {
        if (x == null) {
            return "-";
        }
        return x.toString();
    }

    @Descriptor(value="Show config PIDs.")
    public void pids(PrintStream out, @Descriptor(value="Show stacktraces, too.") @Parameter(names={"-s", "--stacktraces"}, presentValue="true", absentValue="false") boolean stacktraces, @Descriptor(value="Show locations, too.") @Parameter(names={"-l", "--modules"}, presentValue="true", absentValue="false") boolean locations) {
        List pids = this.configurationEngine.listPids();
        int w1 = SvcCommands.calcWidth(pids, 3, ConfigPidInfo::getPid);
        if (locations) {
            int w2 = SvcCommands.calcWidth(pids, 8, ConfigPidInfo::getLocation);
            String fmt = "| %-" + w1 + "s| %-" + w2 + "s|%4s |%4s";
            out.println(String.format(Locale.ENGLISH, fmt, "PID", "Location", "Keys", "Listeners"));
            for (ConfigPidInfo pid : pids) {
                out.println(String.format(Locale.ENGLISH, fmt, pid.getPid(), SvcCommands.norv(pid.getLocation()), SvcCommands.norv(pid.getNkeys()), SvcCommands.norv(pid.getNlisteners())));
            }
        } else {
            String fmt = "| %-" + w1 + "s|%4s |%4s";
            out.println(String.format(Locale.ENGLISH, fmt, "PID", "Keys", "Listeners"));
            for (ConfigPidInfo pid : pids) {
                out.println(String.format(Locale.ENGLISH, fmt, pid.getPid(), SvcCommands.norv(pid.getNkeys()), SvcCommands.norv(pid.getNlisteners())));
                SvcCommands.printThrowables(out, (HasThrowableInfos)pid, stacktraces);
            }
        }
    }

    private static void printMapIndent(PrintStream out, int indent, Map<String, ?> map) {
        String pfx = "  ".repeat(indent);
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Object v = map.get(key);
            if (v instanceof Map) {
                Map sub = (Map)v;
                out.println(pfx + key + ":");
                SvcCommands.printMapIndent(out, indent + 1, sub);
                continue;
            }
            out.println(pfx + key + ": " + String.valueOf(v));
        }
    }

    @Descriptor(value="Show content of config PID.")
    public void config(PrintStream out, @Descriptor(value="Config PIDs to list") @Argument(value="pid") String[] pids) {
        for (String pid : pids) {
            Optional cfg = this.configurationEngine.getPid(pid);
            if (cfg.isEmpty()) {
                out.println("PID " + pid + " not loaded.");
                continue;
            }
            out.println("PID " + pid + ":");
            SvcCommands.printMapIndent(out, 1, ((ConfigWrapper)cfg.get()).getContent());
        }
    }
}

