/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefCountedInputStream
extends InputStream {
    private static final Logger log = LoggerFactory.getLogger(RefCountedInputStream.class);
    private final SharedData data;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public RefCountedInputStream(RefCountedInputStream other) {
        this((InputStream)other);
    }

    public RefCountedInputStream(InputStream other) {
        if (other instanceof RefCountedInputStream) {
            RefCountedInputStream refCounted = (RefCountedInputStream)other;
            this.data = refCounted.data;
            this.data.refs.incrementAndGet();
        } else {
            this.data = new SharedData(other);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        return this.data.underlying.read(b, off, len);
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int read = this.read(buffer, 0, 1);
        return read <= 0 ? -1 : buffer[0];
    }

    @Override
    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        int endRefs = this.data.refs.decrementAndGet();
        if (endRefs <= 0) {
            log.trace("Real close in ref counted input stream for {}", (Object)this.data.underlying);
            this.data.underlying.close();
        }
    }

    public String toString() {
        return "RefCountedInputStream [refCount=" + this.data.refs.get() + ", underlying=" + String.valueOf(this.data.underlying) + "]";
    }

    private static final class SharedData {
        private final InputStream underlying;
        private final AtomicInteger refs = new AtomicInteger(1);

        public SharedData(InputStream underlying) {
            this.underlying = underlying;
        }
    }
}

