/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.util.List;
import org.clazzes.svc.runner.sshd.CliCommand;
import org.clazzes.svc.runner.sshd.CommandEnvironment;
import org.clazzes.svc.runner.sshd.CommandInfo;
import org.clazzes.svc.runner.sshd.CommandResolver;

public class ListResolver
implements CommandResolver {
    private final List<CommandResolver> children;

    public ListResolver(List<CommandResolver> children) {
        this.children = children;
    }

    @Override
    public CliCommand resolveCommand(String commandName, CommandEnvironment env) {
        for (CommandResolver child : this.children) {
            try {
                CliCommand ret = child.resolveCommand(commandName, env);
                if (ret == null) continue;
                return ret;
            }
            catch (Exception e) {
                env.printException(e);
            }
        }
        return null;
    }

    @Override
    public List<CommandInfo> listCommands(String commandNamePrefix, CommandEnvironment env) {
        return this.children.stream().flatMap(child -> child.listCommands(commandNamePrefix, env).stream()).toList();
    }
}

