/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.clazzes.parsercombinators.ParseException;
import org.clazzes.svc.runner.sshd.CommandCompleter;
import org.clazzes.svc.runner.sshd.CommandCompletionMatcher;
import org.clazzes.svc.runner.sshd.CommandEnvironment;
import org.clazzes.svc.runner.sshd.CommandHighlighter;
import org.clazzes.svc.runner.sshd.CommandParser;
import org.clazzes.svc.runner.sshd.CommandResolver;
import org.clazzes.svc.runner.sshd.NoopExpander;
import org.clazzes.svc.runner.sshd.PosixFileDescriptor;
import org.clazzes.svc.runner.sshd.ShellExecutionEngine;
import org.clazzes.svc.runner.sshd.ShellExitException;
import org.jline.reader.Completer;
import org.jline.reader.CompletionMatcher;
import org.jline.reader.EndOfFileException;
import org.jline.reader.Expander;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class InteractiveShell {
    private static final AttributedString bold(String str) {
        return new AttributedString((CharSequence)str, AttributedStyle.BOLD);
    }

    private static final AttributedString mkBranding(String version) {
        return new AttributedStringBuilder().style(AttributedStyle.DEFAULT.foreground(6)).append((CharSequence)"     _________  __ ____           _______ __ __  ____   ____   ___________\n    /  ___/\u2572  \u2572/ // ___\u2572   ______ \u2572_  __ \u2572  |  \u2572/    \u2572 /    \u2572_/ __ \u2572_  __ \u2572\n    \u2572___ \u2572  \u2572   /\u2572  \u2572___  /_____/  |  | \u2572/  |  /   |  \u2572   |  \u2572  ___/|  | \u2572/\n   /_____/   \u2572_/  \u2572_____|          |__|  |____/|___|  /___|  /\u2572___  >__|\n                                                    \u2572/     \u2572/     \u2572/\n".replace('\u2572', '\\').stripTrailing()).style(AttributedStyle.DEFAULT).append((CharSequence)"\n\n").append(InteractiveShell.bold("  clazzes.org svc-runner SSH console")).append((CharSequence)" (").append((CharSequence)version).append((CharSequence)")\n").append((CharSequence)"\n").append((CharSequence)"Hit '").append(InteractiveShell.bold("help")).append((CharSequence)"' for a list of available commands\n").append((CharSequence)"and '").append(InteractiveShell.bold("help [cmd]")).append((CharSequence)"' for help on a specific command.\n").append((CharSequence)"Hit '").append(InteractiveShell.bold("<ctrl-d>")).append((CharSequence)"' or type '").append(InteractiveShell.bold("logout")).append((CharSequence)"' or '").append(InteractiveShell.bold("exit")).append((CharSequence)"' to disconnect shell from current session.\n").toAttributedString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void runInteractiveShell(String version, ExecutorService executor, CommandResolver resolver, Terminal terminal, Map<String, String> envVars, String cwd) {
        terminalFd = PosixFileDescriptor.ofTerminal(terminal);
        try {
            shell = new ShellExecutionEngine(executor, resolver, new CommandEnvironment(envVars, Map.of(0, terminalFd.duplicate(), 1, terminalFd.duplicate(), 2, terminalFd.duplicate()), cwd));
            try {
                InteractiveShell.mkBranding(version).print(terminal);
                completer = new CommandCompleter(shell);
                lineReader = LineReaderBuilder.builder().terminal(terminal).highlighter((Highlighter)new CommandHighlighter(shell)).expander((Expander)new NoopExpander()).parser((Parser)completer).completer((Completer)completer).completionMatcher((CompletionMatcher)new CommandCompletionMatcher()).build();
                user = envVars.get("USER");
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        command = lineReader.readLine(user + ":" + shell.getEnv().cwd() + "$ ");
                        try {
                            shell.executeCommand(CommandParser.parseCommand(command));
                        }
                        catch (ShellExitException e) {
                            return;
                        }
                        catch (ParseException e) {
                            redColoredErrorMessage = new AttributedString((CharSequence)e.getError().getCompositeMessage(), AttributedStyle.DEFAULT.foreground(1));
                            redColoredErrorMessage.println(terminal);
                            continue;
                        }
                        break;
                    }
                }
                catch (EndOfFileException e) {
                    // empty catch block
                    return;
                }
                ** GOTO lbl-1000
            }
            finally {
                shell.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

