/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.clazzes.svc.runner.sshd.CommandEnvironment;
import org.clazzes.svc.runner.sshd.CommandParser;
import org.clazzes.svc.runner.sshd.CommandResolver;
import org.clazzes.svc.runner.sshd.InteractiveShell;
import org.clazzes.svc.runner.sshd.PosixFileDescriptor;
import org.clazzes.svc.runner.sshd.ShellExecutionEngine;
import org.clazzes.svc.runner.sshd.ShellExitException;
import org.jline.builtins.ssh.Ssh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GogoSshHandler {
    private static final Logger log = LoggerFactory.getLogger(GogoSshHandler.class);
    private CommandResolver resolver;
    private ExecutorService executor;
    private String version;

    public void setResolver(CommandResolver resolver) {
        this.resolver = resolver;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void runSingleCommand(Ssh.ExecuteParams params) {
        CommandParser.ParsedCommand parsedCommand = CommandParser.parseCommand(params.getCommand());
        try (ShellExecutionEngine shell2 = new ShellExecutionEngine(this.executor, this.resolver, new CommandEnvironment(params.getEnv(), Map.of(0, PosixFileDescriptor.ofInput(params.getIn()), 1, PosixFileDescriptor.ofOutput(params.getOut()), 2, PosixFileDescriptor.ofOutput(params.getErr())), System.getProperty("user.dir")));){
            shell2.executeCommand(parsedCommand);
        }
        catch (ShellExitException shell2) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void runInteractive(Ssh.ShellParams params) {
        InteractiveShell.runInteractiveShell(this.version, this.executor, this.resolver, params.getTerminal(), params.getEnv(), System.getProperty("user.dir"));
        params.getCloser().run();
    }

    public Consumer<Ssh.ExecuteParams> executeHandler() {
        return this::runSingleCommand;
    }

    public Consumer<Ssh.ShellParams> interactiveHandler() {
        return this::runInteractive;
    }
}

