/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.clazzes.parsercombinators.ParseException;
import org.clazzes.parsercombinators.string.StringParseInput;
import org.clazzes.svc.runner.sshd.CommandParser;
import org.clazzes.svc.runner.sshd.ShellExecutionEngine;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandHighlighter
implements Highlighter {
    private static final Logger log = LoggerFactory.getLogger(CommandHighlighter.class);
    private final ShellExecutionEngine executionEngine;
    private AttributedStyle resolvedCommandStyle = AttributedStyle.DEFAULT.foreground(2);
    private AttributedStyle doubleQuotedStyle = AttributedStyle.DEFAULT.foreground(3);
    private AttributedStyle unresolvedCommandStyle = AttributedStyle.DEFAULT.foreground(9).bold();
    private AttributedStyle parseErrorStyle = AttributedStyle.DEFAULT.foreground(9).bold();
    private static final Comparator<CommandParser.Span> NON_OVERLAPPING = (a, b) -> {
        if (a.start() == b.start() && b.end() == a.end()) {
            return 0;
        }
        if (a.start() < b.start()) {
            if (a.end() > b.start()) {
                log.warn("a = {}", a);
                log.warn("b = {}", b);
                throw new RuntimeException("Overlapping highlight ranges.");
            }
            return -1;
        }
        if (a.start() > b.start()) {
            if (b.end() > a.start()) {
                log.warn("a = {}", a);
                log.warn("b = {}", b);
                throw new RuntimeException("Overlapping highlight ranges.");
            }
            return 1;
        }
        log.warn("a = {}", a);
        log.warn("b = {}", b);
        throw new RuntimeException("Overlapping highlight ranges.");
    };

    public CommandHighlighter(ShellExecutionEngine executionEngine) {
        this.executionEngine = executionEngine;
    }

    private Stream<HighlightSpan> extractDoubleQuotedPartHighlights(CommandParser.DoubleQuotedPart part) {
        if (part instanceof CommandParser.DoubleQuotedPart.QuotedLiteral) {
            CommandParser.DoubleQuotedPart.QuotedLiteral lit = (CommandParser.DoubleQuotedPart.QuotedLiteral)part;
            return Stream.of(new HighlightSpan(lit.span(), this.doubleQuotedStyle));
        }
        if (part instanceof CommandParser.DoubleQuotedPart.CommandSubstitution) {
            CommandParser.DoubleQuotedPart.CommandSubstitution sub = (CommandParser.DoubleQuotedPart.CommandSubstitution)part;
            return this.extractHighlights(sub.command());
        }
        throw new RuntimeException("Unsupported");
    }

    private Stream<HighlightSpan> extractWordPartHighlights(CommandParser.WordPart part) {
        if (part instanceof CommandParser.WordPart.DoubleQuoted) {
            CommandParser.WordPart.DoubleQuoted doubleQuoted = (CommandParser.WordPart.DoubleQuoted)part;
            return Stream.concat(Stream.of(new HighlightSpan(doubleQuoted.openQuoteSpan(), this.doubleQuotedStyle), new HighlightSpan(doubleQuoted.closeQuoteSpan(), this.doubleQuotedStyle)), doubleQuoted.parts().stream().flatMap(this::extractDoubleQuotedPartHighlights));
        }
        if (part instanceof CommandParser.WordPart.Literal) {
            return Stream.empty();
        }
        if (part instanceof CommandParser.WordPart.CommandSubstitution) {
            CommandParser.WordPart.CommandSubstitution sub = (CommandParser.WordPart.CommandSubstitution)part;
            return this.extractHighlights(sub.command());
        }
        throw new RuntimeException("Unsupported");
    }

    private Stream<HighlightSpan> extractWordHighlights(CommandParser.Word word) {
        return word.parts().stream().flatMap(this::extractWordPartHighlights);
    }

    private Stream<HighlightSpan> extractRedirectionKindHighlights(CommandParser.RedirectionKind kind) {
        if (kind instanceof CommandParser.RedirectionKind.Duplicate) {
            CommandParser.RedirectionKind.Duplicate dup = (CommandParser.RedirectionKind.Duplicate)kind;
            return this.extractWordHighlights(dup.duplicatedFd());
        }
        if (kind instanceof CommandParser.RedirectionKind.File) {
            CommandParser.RedirectionKind.File file = (CommandParser.RedirectionKind.File)kind;
            return this.extractWordHighlights(file.word());
        }
        return Stream.empty();
    }

    private Stream<HighlightSpan> extractCommandHighlights(CommandParser.Command command) {
        if (command instanceof CommandParser.Command.Simple) {
            CommandParser.Command.Simple simple = (CommandParser.Command.Simple)command;
            Stream mainWordHighlights = this.executionEngine.expandWordWithoutSideEffects(simple.mainWord()).map(expanded -> this.executionEngine.getResolver().resolveCommand((String)expanded, this.executionEngine.getEnv()) != null ? this.resolvedCommandStyle : this.unresolvedCommandStyle).map(style -> Stream.of(new HighlightSpan(simple.mainWordSpan(), (AttributedStyle)style))).orElseGet(() -> this.extractWordHighlights(simple.mainWord()));
            return Stream.of(mainWordHighlights, simple.assignments().stream().map(CommandParser.AssignmentWord::value).flatMap(this::extractWordHighlights), simple.otherWords().stream().flatMap(this::extractWordHighlights), simple.redirections().stream().map(CommandParser.Redirection::kind).flatMap(this::extractRedirectionKindHighlights)).flatMap(Function.identity());
        }
        throw new RuntimeException("Unsupported");
    }

    private Stream<HighlightSpan> extractHighlights(CommandParser.ParsedCommand script) {
        return script.list().stream().map(listElement -> listElement.andOr()).flatMap(andOr -> Stream.concat(Stream.of(andOr.firstPipeline()), andOr.elements().stream().map(andOrElement -> andOrElement.pipeline()))).flatMap(pipeline -> pipeline.commands().stream()).flatMap(this::extractCommandHighlights);
    }

    private AttributedString attribute(List<HighlightSpan> spans, String str) {
        AttributedStringBuilder builder = new AttributedStringBuilder();
        int prevIndex = 0;
        for (HighlightSpan span : spans) {
            builder.append((CharSequence)new StringParseInput(str, prevIndex, span.span().start()));
            builder.append((CharSequence)new StringParseInput(str, span.span().start(), span.span().end()), span.style());
            prevIndex = span.span().end();
        }
        builder.append((CharSequence)new StringParseInput(str, prevIndex, str.length()));
        return builder.toAttributedString();
    }

    public AttributedString highlight(LineReader reader, String buffer) {
        CommandParser.ParsedCommand command;
        try {
            command = CommandParser.parseCommand(buffer);
        }
        catch (ParseException e) {
            return new AttributedString((CharSequence)buffer, this.parseErrorStyle);
        }
        List<HighlightSpan> highlights = this.extractHighlights(command).sorted(Comparator.comparing(HighlightSpan::span, NON_OVERLAPPING)).toList();
        return this.attribute(highlights, buffer);
    }

    public void setErrorPattern(Pattern errorPattern) {
    }

    public void setErrorIndex(int errorIndex) {
    }

    record HighlightSpan(CommandParser.Span span, AttributedStyle style) {
    }
}

