/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jline.reader.Candidate;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.CompletionMatcher;
import org.jline.reader.LineReader;

public class CommandCompletionMatcher
implements CompletionMatcher {
    private volatile List<Candidate> candidates;
    private volatile CompletingParsedLine parsedLine;

    public void compile(Map<LineReader.Option, Boolean> options, boolean prefix, CompletingParsedLine line, boolean caseInsensitive, int errors, String originalGroupName) {
        this.candidates = null;
        this.parsedLine = line;
    }

    public List<Candidate> matches(List<Candidate> candidates) {
        this.candidates = candidates;
        return candidates;
    }

    public Candidate exactMatch() {
        List<Candidate> candidates = Objects.requireNonNull(this.candidates);
        CompletingParsedLine parsedLine = Objects.requireNonNull(this.parsedLine);
        String givenWord = parsedLine.word();
        for (Candidate candidate : candidates) {
            if (!candidate.complete() || !givenWord.equalsIgnoreCase(candidate.value())) continue;
            return candidate;
        }
        return null;
    }

    static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate(string.charAt(index)) && Character.isLowSurrogate(string.charAt(index + 1));
    }

    private static final String commonPrefix(CharSequence a, CharSequence b) {
        int p;
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        int maxPrefixLength = Math.min(a.length(), b.length());
        for (p = 0; p < maxPrefixLength && a.charAt(p) == b.charAt(p); ++p) {
        }
        if (CommandCompletionMatcher.validSurrogatePairAt(a, p - 1) || CommandCompletionMatcher.validSurrogatePairAt(b, p - 1)) {
            --p;
        }
        return a.subSequence(0, p).toString();
    }

    public String getCommonPrefix() {
        List<Candidate> candidates = Objects.requireNonNull(this.candidates);
        String commonPrefix = null;
        for (Candidate candidate : candidates) {
            if (!candidate.complete()) continue;
            if (commonPrefix == null) {
                commonPrefix = candidate.value();
                continue;
            }
            commonPrefix = CommandCompletionMatcher.commonPrefix(commonPrefix, candidate.value());
        }
        return commonPrefix;
    }
}

