/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.clazzes.parsercombinators.ParseException;
import org.clazzes.svc.runner.sshd.CommandInfo;
import org.clazzes.svc.runner.sshd.CommandParser;
import org.clazzes.svc.runner.sshd.ShellExecutionEngine;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;

public class CommandCompleter
implements Completer,
Parser {
    private final ShellExecutionEngine executionEngine;

    private static final <R, T> Optional<R> firstSome(List<T> list, Function<T, Optional<R>> fn) {
        for (T i : list) {
            Optional<R> value = fn.apply(i);
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }

    private static final Optional<WordWithSpan> extractDoubleQuotedPartMainWord(CommandParser.DoubleQuotedPart part, int cursor) {
        if (part instanceof CommandParser.DoubleQuotedPart.CommandSubstitution) {
            CommandParser.DoubleQuotedPart.CommandSubstitution sub = (CommandParser.DoubleQuotedPart.CommandSubstitution)part;
            return CommandCompleter.extractMainWord(sub.command(), cursor);
        }
        if (part instanceof CommandParser.DoubleQuotedPart.QuotedLiteral) {
            CommandParser.DoubleQuotedPart.QuotedLiteral lit = (CommandParser.DoubleQuotedPart.QuotedLiteral)part;
            return Optional.empty();
        }
        throw new RuntimeException("Unsupported");
    }

    private static final Optional<WordWithSpan> extractWordPartMainWord(CommandParser.WordPart part, int cursor) {
        if (part instanceof CommandParser.WordPart.CommandSubstitution) {
            CommandParser.WordPart.CommandSubstitution sub = (CommandParser.WordPart.CommandSubstitution)part;
            return CommandCompleter.extractMainWord(sub.command(), cursor);
        }
        if (part instanceof CommandParser.WordPart.Literal) {
            CommandParser.WordPart.Literal lit = (CommandParser.WordPart.Literal)part;
            return Optional.empty();
        }
        if (part instanceof CommandParser.WordPart.DoubleQuoted) {
            CommandParser.WordPart.DoubleQuoted doubleQuoted = (CommandParser.WordPart.DoubleQuoted)part;
            return CommandCompleter.firstSome(doubleQuoted.parts(), dqPart -> CommandCompleter.extractDoubleQuotedPartMainWord(dqPart, cursor));
        }
        throw new RuntimeException("Unsupported");
    }

    private static final Optional<WordWithSpan> extractWordMainWord(CommandParser.Word word, int cursor) {
        return CommandCompleter.firstSome(word.parts(), wordPart -> CommandCompleter.extractWordPartMainWord(wordPart, cursor));
    }

    private static final Optional<WordWithSpan> extractRedirectionKindMainWord(CommandParser.RedirectionKind kind, int cursor) {
        if (kind instanceof CommandParser.RedirectionKind.Duplicate) {
            CommandParser.RedirectionKind.Duplicate dup = (CommandParser.RedirectionKind.Duplicate)kind;
            return CommandCompleter.extractWordMainWord(dup.duplicatedFd(), cursor);
        }
        if (kind instanceof CommandParser.RedirectionKind.File) {
            CommandParser.RedirectionKind.File file = (CommandParser.RedirectionKind.File)kind;
            return CommandCompleter.extractWordMainWord(file.word(), cursor);
        }
        if (kind instanceof CommandParser.RedirectionKind.HereDocument) {
            return Optional.empty();
        }
        throw new RuntimeException("Unsupported");
    }

    private static final Optional<WordWithSpan> extractCommandMainWord(CommandParser.Command command, int cursor) {
        if (command instanceof CommandParser.Command.Simple) {
            CommandParser.Command.Simple simple = (CommandParser.Command.Simple)command;
            return CommandCompleter.extractWordMainWord(simple.mainWord(), cursor).or(() -> cursor >= simple.mainWordSpan().start() && cursor <= simple.mainWordSpan().end() ? Optional.of(new WordWithSpan(simple.mainWord(), simple.mainWordSpan())) : Optional.empty()).or(() -> CommandCompleter.firstSome(simple.otherWords(), otherWord -> CommandCompleter.extractWordMainWord(otherWord, cursor))).or(() -> CommandCompleter.firstSome(simple.assignments(), assignment -> CommandCompleter.extractWordMainWord(assignment.value(), cursor))).or(() -> CommandCompleter.firstSome(simple.redirections(), redirection -> CommandCompleter.extractRedirectionKindMainWord(redirection.kind(), cursor)));
        }
        throw new RuntimeException("Unsupported");
    }

    private static final Optional<WordWithSpan> extractPipelineMainWord(CommandParser.Pipeline pipeline, int cursor) {
        return CommandCompleter.firstSome(pipeline.commands(), command -> CommandCompleter.extractCommandMainWord(command, cursor));
    }

    private static final Optional<WordWithSpan> extractMainWord(CommandParser.ParsedCommand command, int cursor) {
        return CommandCompleter.firstSome(command.list(), posixElement -> CommandCompleter.extractPipelineMainWord(posixElement.andOr().firstPipeline(), cursor).or(() -> CommandCompleter.firstSome(posixElement.andOr().elements(), andOrElement -> CommandCompleter.extractPipelineMainWord(andOrElement.pipeline(), cursor))));
    }

    public CommandCompleter(ShellExecutionEngine executionEngine) {
        this.executionEngine = executionEngine;
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        CommandParser.ParsedCommand command;
        String commandString = line.line();
        int cursor = line.cursor();
        try {
            command = CommandParser.parseCommand(commandString);
        }
        catch (ParseException e) {
            return;
        }
        Optional<WordWithSpan> mainWordOpt = CommandCompleter.extractMainWord(command, cursor);
        if (!mainWordOpt.isPresent()) {
            return;
        }
        CommandParser.Span mainWordSpan = mainWordOpt.get().span();
        CommandParser.Word mainWord = mainWordOpt.get().word();
        if (cursor != mainWordSpan.end()) {
            return;
        }
        Optional<String> expanded = this.executionEngine.expandWordWithoutSideEffects(mainWord);
        if (!expanded.isPresent()) {
            return;
        }
        String prefix = expanded.get();
        List<CommandInfo> resolverCandidates = this.executionEngine.getResolver().listCommands(prefix, this.executionEngine.getEnv());
        for (CommandInfo candidate : resolverCandidates) {
            candidates.add(new Candidate(candidate.name().substring(prefix.length()), candidate.name(), null, null, null, null, true, 0));
        }
    }

    public ParsedLine parse(final String line, final int cursor, Parser.ParseContext context) throws SyntaxError {
        final String word = "";
        final List<String> words = List.of(line.substring(0, cursor), word, line.substring(cursor));
        return new CompletingParsedLine(){

            public String word() {
                return word;
            }

            public int wordCursor() {
                return 0;
            }

            public int wordIndex() {
                return 1;
            }

            public List<String> words() {
                return words;
            }

            public String line() {
                return line;
            }

            public int cursor() {
                return cursor;
            }

            public CharSequence escape(CharSequence candidate, boolean complete) {
                return candidate;
            }

            public int rawWordCursor() {
                return 0;
            }

            public int rawWordLength() {
                return 0;
            }
        };
    }

    record WordWithSpan(CommandParser.Word word, CommandParser.Span span) {
    }
}

