/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.io.IOException;
import java.io.OutputStream;

public class CloseProtectedOutputStream
extends OutputStream {
    private boolean closed = false;
    private final OutputStream underlying;

    public CloseProtectedOutputStream(OutputStream underlying) {
        this.underlying = underlying;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.underlying.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.underlying.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        this.closed = true;
    }

    public String toString() {
        return "CloseProtectedOutputStream [underlying=" + String.valueOf(this.underlying) + "]";
    }
}

