/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.sshd;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CRLFOutputStream
extends FilterOutputStream {
    private int lastByte = -1;
    private static final byte[] CRLF = new byte[]{13, 10};

    public CRLFOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 10 && this.lastByte != 13) {
            this.out.write(CRLF);
        } else {
            this.out.write(b);
        }
        this.lastByte = b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int last = 0;
        for (int i = 0; i < len; ++i) {
            byte c = b[off + i];
            if (c == 10 && this.lastByte != 13) {
                if (i > last) {
                    this.out.write(b, off + last, i - last);
                }
                this.out.write(CRLF);
                last = i + 1;
            }
            this.lastByte = c & 0xFF;
        }
        if (len > last) {
            this.out.write(b, off + last, len - last);
        }
    }
}

