package org.clazzes.svc.runner.sshd;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

import org.jline.builtins.ssh.Ssh;

public class GogoSshHandler {
    @SuppressWarnings("unused")
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(GogoSshHandler.class);


    private CommandResolver resolver;
    public void setResolver(CommandResolver resolver) {
        this.resolver = resolver;
    }

    private ExecutorService executor;
    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    private String version;
    public void setVersion(String version) {
        this.version = version;
    }



    public void runSingleCommand(Ssh.ExecuteParams params) {
        var parsedCommand = CommandParser.parseCommand(params.getCommand());
        try (var shell = new ShellExecutionEngine(
            this.executor,
            this.resolver,
            new CommandEnvironment(
                // TODO: Should we mix the ssh environment variables with the environment varaibles of this java process?
                params.getEnv(),
                Map.of(
                    0, PosixFileDescriptor.ofInput(params.getIn()),
                    1, PosixFileDescriptor.ofOutput(params.getOut()),
                    2, PosixFileDescriptor.ofOutput(params.getErr())
                ),
                System.getProperty("user.dir")
            )
        )) {
            shell.executeCommand(parsedCommand);
        } catch (ShellExitException e) {
            // IGNORE
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

    }

    public void runInteractive(Ssh.ShellParams params) {
        InteractiveShell.runInteractiveShell(
            this.version,
            this.executor,
            this.resolver,
            params.getTerminal(),
            // TODO: Should we mix the ssh environment variables with the environment varaibles of this java process?
            params.getEnv(),
            System.getProperty("user.dir")
        );

        params.getCloser().run();
    }

    public Consumer<Ssh.ExecuteParams> executeHandler() {
        return this::runSingleCommand;
    }

    public Consumer<Ssh.ShellParams> interactiveHandler() {
        return this::runInteractive;
    }
}
