package org.clazzes.svc.runner.sshd;

import java.util.function.Function;

public class ExceptionFnUtil {
    @SuppressWarnings("unchecked")
    public static final <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw (E) e;
    }

    @FunctionalInterface
    public interface ExceptionFn<T, R> {
        public R apply(T var1) throws Exception;
    }

    public static final <T, R> Function<T, R> sneakyFn(ExceptionFn<T, R> fn) {
        return a -> {
            try {
                return fn.apply(a);
            } catch (Exception e) {
                sneakyThrow(e);
                return null;
            }
        };
    }
}
