/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.runner.monitoring;

import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.clazzes.svc.api.monitoring.AsyncMetrics;
import org.clazzes.svc.api.monitoring.Counter;
import org.clazzes.svc.api.monitoring.Gauge;
import org.clazzes.svc.api.monitoring.HealthCheck;
import org.clazzes.svc.api.monitoring.HealthInfo;
import org.clazzes.svc.api.monitoring.HealthStatus;
import org.clazzes.svc.api.monitoring.Histogram;
import org.clazzes.svc.api.monitoring.Summary;
import org.clazzes.svc.api.monitoring.TaggedMetrics;
import org.clazzes.svc.runner.monitoring.CounterResult;
import org.clazzes.svc.runner.monitoring.GaugeResult;
import org.clazzes.svc.runner.monitoring.HealthCheckResult;
import org.clazzes.svc.runner.monitoring.IActiveMetrics;
import org.clazzes.svc.runner.monitoring.OpenMetricsType;
import org.clazzes.svc.runner.monitoring.Result;
import org.clazzes.svc.runner.monitoring.ResultHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsHolder<T extends Comparable<T>>
implements Runnable,
IActiveMetrics<T> {
    private static final Logger log = LoggerFactory.getLogger(MetricsHolder.class);
    private final TaggedMetrics metrics;
    private final Callable<Result<T>> callable;
    private final Function<Long, Result<T>> initialFactory;
    private final Function<Throwable, Result<T>> exceptionFactory;
    private final OpenMetricsType openMetricsType;
    private final long createdMillis;
    private final AtomicInteger runCount;
    private Result<T> lastResult;
    private long timeoutNanos;
    private Future<?> future;
    private final ResultHistory<T> history;

    protected MetricsHolder(TaggedMetrics metrics, int keepResultsSeconds, Callable<Result<T>> callable, Function<Long, Result<T>> initialFactory, Function<Throwable, Result<T>> exceptionFactory, Function<Double, Result<T>> doubleFactory) {
        this.metrics = metrics;
        this.callable = callable;
        this.initialFactory = initialFactory;
        this.exceptionFactory = exceptionFactory;
        this.createdMillis = System.currentTimeMillis();
        this.runCount = new AtomicInteger();
        this.timeoutNanos = this.metrics.getTTLMillis() * 1000000L;
        ResultHistory<T> resultHistory = this.history = metrics instanceof Summary || metrics instanceof Histogram ? new ResultHistory<T>((long)keepResultsSeconds * 1000000000L, doubleFactory) : null;
        OpenMetricsType om = metrics instanceof Summary ? OpenMetricsType.summary : (metrics instanceof Histogram ? OpenMetricsType.histogram : (metrics instanceof Counter ? OpenMetricsType.counter : OpenMetricsType.gauge));
        this.openMetricsType = om;
    }

    public static MetricsHolder<HealthInfo> ofHealthCheck(HealthCheck hc, int keepResultsSeconds) {
        return new MetricsHolder<HealthInfo>((TaggedMetrics)hc, keepResultsSeconds, () -> new HealthCheckResult((HealthInfo)hc.call()), interval -> new HealthCheckResult(new HealthInfo(HealthStatus.WARN, "First execution in [" + interval + "s]...")), e -> new HealthCheckResult((Throwable)e), d -> new HealthCheckResult(d == null ? null : HealthInfo.ofValue((double)d)));
    }

    public static MetricsHolder<Long> ofCounter(Counter ctr, int keepResultsSeconds) {
        return new MetricsHolder<Long>((TaggedMetrics)ctr, keepResultsSeconds, () -> new CounterResult((Long)ctr.call()), null, e -> new CounterResult((Throwable)e), d -> new CounterResult(d == null ? null : Long.valueOf(d.longValue())));
    }

    public static MetricsHolder<Double> ofGauge(Gauge gauge, int keepResultsSeconds) {
        return new MetricsHolder<Double>((TaggedMetrics)gauge, keepResultsSeconds, () -> new GaugeResult((Double)gauge.call()), null, e -> new GaugeResult((Throwable)e), d -> new GaugeResult((Double)d));
    }

    @Override
    public TaggedMetrics getTaggedMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putResult(Result<T> r) {
        MetricsHolder metricsHolder = this;
        synchronized (metricsHolder) {
            this.lastResult = r;
            this.notifyAll();
        }
        if (this.history != null) {
            this.history.putResult(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: {
            try {
                if (this.runCount.incrementAndGet() == 1) {
                    Result<T> r;
                    long startNanos = System.nanoTime();
                    try {
                        r = this.callable.call();
                    }
                    catch (Exception e) {
                        r = this.exceptionFactory.apply(e);
                    }
                    r.calculateDuration(startNanos);
                    this.putResult(r);
                    break block8;
                }
                log.warn("Concurrent execution of metrics [{}] detected, waiting for primary exection.", (Object)this.metrics.getClass().getName());
                this.wait(60000L);
            }
            catch (InterruptedException e) {
                log.warn("Wait for concurrent execution of metrics [{}] has been interrupted.", (Object)this.metrics.getClass().getName(), (Object)e);
            }
            finally {
                this.runCount.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schedule(ScheduledExecutorService executorService) {
        TaggedMetrics taggedMetrics = this.metrics;
        if (taggedMetrics instanceof AsyncMetrics) {
            AsyncMetrics am = (AsyncMetrics)taggedMetrics;
            long interval = am.getIntervalSeconds();
            if (interval > 0L) {
                log.info("Scheduling metrics [{}] with interval [{}s].", (Object)this.metrics.getId(), (Object)interval);
                if (this.initialFactory != null) {
                    MetricsHolder metricsHolder = this;
                    synchronized (metricsHolder) {
                        this.lastResult = this.initialFactory.apply(interval);
                    }
                }
                this.future = executorService.scheduleAtFixedRate(this, interval, interval, TimeUnit.SECONDS);
                return true;
            }
            log.info("Metrics [{}] with interval [{}s] with be executed synchronously.", (Object)this.metrics.getId(), (Object)interval);
            return false;
        }
        return false;
    }

    public synchronized boolean isScheduled() {
        return this.future != null;
    }

    public synchronized void shutdown() {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<T> getResult() {
        boolean doRun;
        MetricsHolder metricsHolder = this;
        synchronized (metricsHolder) {
            doRun = this.future == null && (this.lastResult == null || System.nanoTime() - this.lastResult.getNanoTime() >= this.timeoutNanos);
        }
        if (doRun) {
            this.run();
        }
        metricsHolder = this;
        synchronized (metricsHolder) {
            return this.lastResult;
        }
    }

    @Override
    public OpenMetricsType getOpenMetricsType() {
        return this.openMetricsType;
    }

    @Override
    public long getCreatedMillis() {
        return this.createdMillis;
    }

    @Override
    public SortedMap<Double, Number> getSummary() {
        TaggedMetrics taggedMetrics = this.metrics;
        if (taggedMetrics instanceof Summary) {
            Summary summary = (Summary)taggedMetrics;
            return this.history.getSummary(summary.getQuantiles());
        }
        throw new UnsupportedOperationException("Cannot generate summary for non-summary metrics.");
    }

    @Override
    public SortedMap<Double, Integer> getHistogram() {
        TaggedMetrics taggedMetrics = this.metrics;
        if (taggedMetrics instanceof Histogram) {
            Histogram histogram = (Histogram)taggedMetrics;
            return this.history.getHistogram(histogram.getLEValues());
        }
        throw new UnsupportedOperationException("Cannot generate histogram for non-histogram metrics.");
    }

    @Override
    public List<Result<T>> getHistory() {
        if (this.history == null) {
            return null;
        }
        return this.history.getHistory();
    }
}

