package org.clazzes.svc.runner.monitoring.system;

import java.util.List;
import java.util.Locale;

import org.clazzes.svc.api.monitoring.HealthInfo;
import org.clazzes.svc.api.monitoring.HealthStatus;

public class MemoryHealthCheck extends SystemHealthCheckSupport {

    private static final double MB_FACTOR = 1.0 / 1024.0 / 1024.0;

    public MemoryHealthCheck(double warningPercentage, double criticalPercentage) {
        super(warningPercentage,criticalPercentage);
    }

    @Override
    public HealthInfo call() throws Exception {

        Runtime runtime = Runtime.getRuntime();

        double totalMB = runtime.totalMemory() * MB_FACTOR;
        double freeMB = runtime.freeMemory() * MB_FACTOR;

        double percentage = 100.0 * (1.0 - freeMB / totalMB);

        if (percentage < warningPercentage) {
            return new HealthInfo(HealthStatus.OK,
                String.format(Locale.ENGLISH,
                    "Memory usage [%.1f%%<%.1f%%], free memory [%.1fMiB/%.1fMiB]",
                    percentage,this.warningPercentage,freeMB,totalMB));
        }
        else if (percentage < criticalPercentage) {

            return new HealthInfo(HealthStatus.WARN,
                String.format(Locale.ENGLISH,
                    "Memory usage [%.1f%%\u2264%.1f%%<%.1f%%], free memory [%.1fMiB/%.1fMiB]",
                    this.warningPercentage,percentage,this.criticalPercentage,freeMB,totalMB));
        }
        else {

            return new HealthInfo(HealthStatus.CRITICAL,
                String.format(Locale.ENGLISH,
                    "Memory usage [%.1f%%\u2264%.1f%%], free memory [%.1fMiB/%.1fMiB]",
                    this.criticalPercentage,percentage,freeMB,totalMB));
        }
    }

    @Override
    public String getId() {
        return "system.memory";
    }

    @Override
    public String getDescription() {
        return "Check the memory usage against Thresholds [warn="+
                this.warningPercentage+"%,critical="+
                this.criticalPercentage+"%]";
    }

    @Override
    public List<String> getTags() {
        return List.of("system","memory");
    }

}
