package org.clazzes.svc.runner.monitoring.system;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.List;
import java.util.Locale;

import org.clazzes.svc.api.monitoring.HealthInfo;
import org.clazzes.svc.api.monitoring.HealthStatus;

public class CPUHealthCheck extends SystemHealthCheckSupport {

    public CPUHealthCheck(double warningPercentage, double criticalPercentage) {
        super(warningPercentage,criticalPercentage);
    }

    @Override
    public HealthInfo call() throws Exception {

        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();

        double cLoad = operatingSystemMXBean.getSystemLoadAverage();
        double mLoad = operatingSystemMXBean.getAvailableProcessors();

        double percentage = 100.0 * (cLoad/mLoad);

        if (percentage < this.warningPercentage) {
            return new HealthInfo(HealthStatus.OK,
                String.format(Locale.ENGLISH,
                    "CPU usage [%.1f%%<%.1f%%], load [%.2f/%.2f]",
                    percentage,this.warningPercentage,cLoad,mLoad));
        }
        else if (percentage < this.criticalPercentage) {

            return new HealthInfo(HealthStatus.WARN,
                String.format(Locale.ENGLISH,
                    "CPU usage [%.1f%%\u2264%.1f%%<%.1f%%], load [%.2f/%.2f]",
                    this.warningPercentage,percentage,this.criticalPercentage,cLoad,mLoad));
        }
        else {

            return new HealthInfo(HealthStatus.CRITICAL,
                String.format(Locale.ENGLISH,
                    "CPU usage [%.1f%%\u2264%.1f%%], load [%.2f/%.2f]",
                    this.criticalPercentage,percentage,cLoad,mLoad));
        }
    }

    @Override
    public String getId() {
        return "system.cpu";
    }

    @Override
    public String getDescription() {
        return "Check the CPU usage against Thresholds [warn="+
                this.warningPercentage+"%,critical="+
                this.criticalPercentage+"%]";
    }

    @Override
    public List<String> getTags() {
        return List.of("system","cpu");
    }

}
