/***********************************************************
 *
 * Service Runner framework runner using commons-daemon
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.svc.runner.monitoring;

import java.util.List;
import java.util.SortedMap;

import org.clazzes.svc.api.monitoring.TaggedMetrics;

public interface IActiveMetrics<T extends Comparable<T>> {

    /**
     * @return The underlying metrics object for fetching descriptions and tags.
     */
    public TaggedMetrics getTaggedMetrics();

    /**
     * @return The latest result of this metrics. non-async metrics
     *         are evaluated by this call.
     */
    Result<T> getResult();

    /**
     * @return The open metrics type.
     */
    OpenMetricsType getOpenMetricsType();

    /**
     * @return The timestamp at which this metric has been actviated.
     */
    long getCreatedMillis();

    /**
     * @return An OpenMetrics summary.
     * @throws UnsupportedOperationException For non-summary metrics.
     */
    SortedMap<Double, Number> getSummary();

    /**
     * @return An OpenMetrics histogram.
     * @throws UnsupportedOperationException For non-gistogram metrics.
     */
    SortedMap<Double, Integer> getHistogram();

    /**
     * @return The history of collected results or <code>null</code>, if
     *         this is a non-async metrics.
     */
    List<Result<T>> getHistory();

}